/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.artifact.declaration.request;

import org.mule.runtime.api.app.declaration.ArtifactDeclaration;
import org.mule.tooling.client.api.request.AbstractToolingRequest;

/**
 * Request entity for obtaining a serialized representation of the given {@link ArtifactDeclaration}
 *
 * @since 1.0
 */
public final class JsonArtifactSerializationRequest extends AbstractToolingRequest {

  private boolean prettyPrint;
  private ArtifactDeclaration artifactDeclaration;

  public JsonArtifactSerializationRequest() {}

  /**
   * Creates a new instance of an {@link JsonArtifactSerializationRequest}
   *
   * @param artifactDeclaration the {@link ArtifactDeclaration} to be serialized
   */
  public JsonArtifactSerializationRequest(ArtifactDeclaration artifactDeclaration) {
    this.artifactDeclaration = artifactDeclaration;
  }

  /**
   * Creates a new instance of an {@link JsonArtifactSerializationRequest}
   *
   * @param artifactDeclaration the {@link ArtifactDeclaration} to be serialized
   * @param prettyPrint whether or not to enable pretty printing
   */
  public JsonArtifactSerializationRequest(ArtifactDeclaration artifactDeclaration, boolean prettyPrint) {
    this.artifactDeclaration = artifactDeclaration;
    this.prettyPrint = prettyPrint;
  }

  /**
   * @return the {@link ArtifactDeclaration} to be serialized converted
   */
  public ArtifactDeclaration getArtifactDeclaration() {
    return artifactDeclaration;
  }

  public boolean isPrettyPrint() {
    return prettyPrint;
  }

}

