/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.metadata;

import org.mule.tooling.client.api.types.UnknownType;

/**
 * Standard error codes to describe common errors that may occur during
 * Metadata fetching operations
 *
 * @since 1.0
 */
public final class FailureCode extends UnknownType {

  private boolean noDynamicTypeAvailable = false;
  private boolean noDynamicKeyAvailable = false;
  private boolean invalidConfiguration = false;
  private boolean resourceUnavailable = false;
  private boolean invalidMetadataKet = false;
  private boolean invalidCredentials = false;
  private boolean connectionFailure = false;
  private boolean notAuthorized = false;
  private boolean componentNotFound = false;
  private boolean applicationNotFound = false;
  private boolean none = false;
  private boolean noDynamicMetadataAvailable = false;

  public FailureCode(String name) {
    super(name);
  }

  public static FailureCode noDynamicTypeAvailableFailureCode(String name) {
    FailureCode code = new FailureCode(name);
    code.noDynamicTypeAvailable = true;
    return code;
  }

  public static FailureCode noDynamicKeyAvailableFailureCode(String name) {
    FailureCode code = new FailureCode(name);
    code.noDynamicKeyAvailable = true;
    return code;
  }

  public static FailureCode invalidConfigurationFailureCode(String name) {
    FailureCode code = new FailureCode(name);
    code.invalidConfiguration = true;
    return code;
  }

  public static FailureCode resourceUnavailableFailureCode(String name) {
    FailureCode code = new FailureCode(name);
    code.resourceUnavailable = true;
    return code;
  }

  public static FailureCode invalidMetadataKetFailureCode(String name) {
    FailureCode code = new FailureCode(name);
    code.invalidMetadataKet = true;
    return code;
  }

  public static FailureCode invalidCredentialsFailureCode(String name) {
    FailureCode code = new FailureCode(name);
    code.invalidCredentials = true;
    return code;
  }

  public static FailureCode connectionFailureFailureCode(String name) {
    FailureCode code = new FailureCode(name);
    code.connectionFailure = true;
    return code;
  }

  public static FailureCode notAuthorizedFailureCode(String name) {
    FailureCode code = new FailureCode(name);
    code.notAuthorized = true;
    return code;
  }

  public static FailureCode componentNotFoundFailureCode(String name) {
    FailureCode code = new FailureCode(name);
    code.componentNotFound = true;
    return code;
  }

  public static FailureCode applicationNotFoundFailureCode(String name) {
    FailureCode code = new FailureCode(name);
    code.applicationNotFound = true;
    return code;
  }

  public static FailureCode noneFailureCode(String name) {
    FailureCode code = new FailureCode(name);
    code.none = true;
    return code;
  }

  public static FailureCode noDynamicMetadataAvailableFailureCode(String name) {
    FailureCode code = new FailureCode(name);
    code.noDynamicMetadataAvailable = true;
    return code;
  }

  @Override
  public boolean equals(Object obj) {
    return obj instanceof FailureCode && this.getValue().equals(((FailureCode) obj).getValue());
  }

  @Override
  public int hashCode() {
    return getValue().hashCode();
  }

  public boolean isApplicationNotFound() {
    return applicationNotFound;
  }

  public boolean isComponentNotFound() {
    return componentNotFound;
  }

  public boolean isConnectionFailure() {
    return connectionFailure;
  }

  public boolean isInvalidConfiguration() {
    return invalidConfiguration;
  }

  public boolean isInvalidCredentials() {
    return invalidCredentials;
  }

  public boolean isInvalidMetadataKet() {
    return invalidMetadataKet;
  }

  public boolean isNoDynamicKeyAvailable() {
    return noDynamicKeyAvailable;
  }

  public boolean isNoDynamicMetadataAvailable() {
    return noDynamicMetadataAvailable;
  }

  public boolean isNoDynamicTypeAvailable() {
    return noDynamicTypeAvailable;
  }

  public boolean isNone() {
    return none;
  }

  public boolean isNotAuthorized() {
    return notAuthorized;
  }

  public boolean isResourceUnavailable() {
    return resourceUnavailable;
  }

}
