/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.extension.model.source;

import static java.util.Optional.ofNullable;
import org.mule.tooling.client.api.extension.model.DisplayModel;
import org.mule.tooling.client.api.extension.model.ErrorModel;
import org.mule.tooling.client.api.extension.model.ExtensionModel;
import org.mule.tooling.client.api.extension.model.OutputModel;
import org.mule.tooling.client.api.extension.model.Stereotype;
import org.mule.tooling.client.api.extension.model.nested.NestableElementModel;
import org.mule.tooling.client.api.extension.model.parameter.ParameterGroupModel;
import org.mule.tooling.client.api.extension.model.parameter.ParameterModel;

import java.util.List;
import java.util.Optional;
import java.util.Set;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

/**
 * A definition of a message source in an {@link ExtensionModel}.
 *
 * @since 1.0
 */
public class SourceModel {

  private String name;
  private String description;
  private List<ParameterGroupModel> parameterGroupModels;
  private DisplayModel displayModel;
  private OutputModel output;
  private OutputModel outputAttributes;
  private boolean transactional;
  private boolean requiresConnection;
  private boolean supportsStreaming;
  private Set<Stereotype> stereotypes;
  private boolean hasResponse;
  private SourceCallbackModel successCallback;
  private SourceCallbackModel errorCallback;
  private SourceCallbackModel terminateCallbackModel;
  private Set<ErrorModel> errors;
  private List<? extends NestableElementModel> nestedComponents;

  // Just needed in order to serialize this object
  private SourceModel() {}

  public SourceModel(String name, String description,
                     List<ParameterGroupModel> parameterGroupModels,
                     DisplayModel displayModel, OutputModel output,
                     OutputModel outputAttributes, boolean transactional, boolean requiresConnection,
                     boolean supportsStreaming,
                     Set<Stereotype> stereotypes, boolean hasResponse,
                     SourceCallbackModel successCallback,
                     SourceCallbackModel errorCallback,
                     SourceCallbackModel terminateCallbackModel,
                     Set<ErrorModel> errors,
                     List<? extends NestableElementModel> nestedComponents) {
    this.name = name;
    this.description = description;
    this.parameterGroupModels = parameterGroupModels;
    this.displayModel = displayModel;
    this.output = output;
    this.outputAttributes = outputAttributes;
    this.transactional = transactional;
    this.requiresConnection = requiresConnection;
    this.supportsStreaming = supportsStreaming;
    this.stereotypes = stereotypes;
    this.hasResponse = hasResponse;
    this.successCallback = successCallback;
    this.errorCallback = errorCallback;
    this.terminateCallbackModel = terminateCallbackModel;
    this.errors = errors;
    this.nestedComponents = nestedComponents;
  }

  public String getName() {
    return name;
  }

  public String getDescription() {
    return description;
  }

  public List<ParameterGroupModel> getParameterGroupModels() {
    return parameterGroupModels;
  }

  public Optional<DisplayModel> getDisplayModel() {
    return ofNullable(displayModel);
  }

  public OutputModel getOutput() {
    return output;
  }

  public OutputModel getOutputAttributes() {
    return outputAttributes;
  }

  public boolean isTransactional() {
    return transactional;
  }

  public boolean requiresConnection() {
    return requiresConnection;
  }

  public boolean supportsStreaming() {
    return supportsStreaming;
  }

  public Set<Stereotype> getStereotypes() {
    return stereotypes;
  }

  public boolean hasResponse() {
    return hasResponse;
  }

  public Optional<SourceCallbackModel> getSuccessCallback() {
    return ofNullable(successCallback);
  }

  public Optional<SourceCallbackModel> getErrorCallback() {
    return ofNullable(errorCallback);
  }

  public Optional<SourceCallbackModel> getTerminateCallback() {
    return ofNullable(terminateCallbackModel);
  }

  public Set<ErrorModel> getErrorModels() {
    return errors;
  }

  public List<? extends NestableElementModel> getNestedComponents() {
    return nestedComponents;
  }

  @Override
  public int hashCode() {
    return this.name.hashCode();
  }

  @Override
  public boolean equals(Object obj) {
    return this.getClass().isInstance(obj) && this.name.equals(((ParameterModel) obj).getName());
  }

  @Override
  public String toString() {
    return ReflectionToStringBuilder.toString(this);
  }

}
