/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.extension.model.nested;

import org.mule.tooling.client.api.extension.model.DisplayModel;
import org.mule.tooling.client.api.extension.model.Stereotype;

import java.util.Set;

/**
 * Represents a {@link NestableElementModel} that makes reference to a single ComponentModel
 *
 * @since 1.0
 */
public class NestedComponentModel implements NestableElementModel {

  private boolean isRequired;
  private String name;
  private String description;
  private DisplayModel displayModel;
  private Set<Stereotype> allowedStereotypes;

  public NestedComponentModel() {}

  /**
   * Creates a new instance
   *
   * @param name            the model's name
   * @param description     the model's description
   * @param isRequired      whether or not this component is required
   * @param allowedStereotypes     A {@link Set} of custom properties which extend this model
   * @param displayModel    a model containing directives about how this component is to be displayed in the UI
   * @throws IllegalArgumentException if {@code name} is blank
   */
  public NestedComponentModel(String name, String description, DisplayModel displayModel,
                              boolean isRequired, Set<Stereotype> allowedStereotypes) {
    this.isRequired = isRequired;
    this.allowedStereotypes = allowedStereotypes;
    this.name = name;
    this.description = description;
    this.displayModel = displayModel;
  }

  public Set<Stereotype> getAllowedStereotypes() {
    return allowedStereotypes;
  }

  public boolean isRequired() {
    return isRequired;
  }

  public String getName() {
    return name;
  }

  public String getDescription() {
    return description;
  }

  public DisplayModel getDisplayModel() {
    return displayModel;
  }
}
