/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.datasense;

import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.api.extension.model.operation.OperationModel;
import org.mule.tooling.client.api.extension.model.source.SourceModel;
import org.mule.tooling.client.api.location.Location;

import java.util.List;
import java.util.Map;
import java.util.Optional;

import static java.util.Optional.ofNullable;

public class DataSenseInfo {

  private MetadataType input;
  private MetadataType output;
  private MetadataType income;
  private MetadataType expected;
  private MetadataType actualInput;
  private MetadataType actualOutput;
  private MetadataType expectedInput;
  private MetadataType expectedOutput;
  private MetadataType result;
  private OperationModel operationModel;
  private SourceModel sourceModel;
  private List<String> messages;
  private Location location;
  private Map<Location, DataSenseElementInfo> componentInfoByComponentPath;
  private List<DataSenseNotification> notifications;

  public Location getLocation() {
    return location;
  }

  public Optional<MetadataType> getInput() {
    return ofNullable(input);
  }

  public Optional<MetadataType> getOutput() {
    return ofNullable(output);
  }

  public Optional<MetadataType> getIncoming() {
    return ofNullable(income);
  }

  public Optional<MetadataType> getExpected() {
    return ofNullable(expected);
  }

  public Optional<MetadataType> getActualInput() {
    return ofNullable(actualInput);
  }

  public Optional<MetadataType> getActualOutput() {
    return ofNullable(actualOutput);
  }

  public Optional<MetadataType> getExpectedInput() {
    return ofNullable(expectedInput);
  }

  public Optional<MetadataType> getExpectedOutput() {
    return ofNullable(expectedOutput);
  }

  public Optional<MetadataType> getResult() {
    return ofNullable(result);
  }

  public Optional<OperationModel> getOperationModel() {
    return ofNullable(operationModel);
  }

  public Optional<SourceModel> getSourceModel() {
    return ofNullable(sourceModel);
  }

  public List<String> getMessages() {
    return messages;
  }

  public List<DataSenseNotification> getDataSenseNotifications() {
    return notifications;
  }

  public Optional<Map<Location, DataSenseElementInfo>> getComponentInfoByComponentPath() {
    return ofNullable(componentInfoByComponentPath);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {

    DataSenseInfo dataSenseInfo = new DataSenseInfo();

    public Builder withLocation(Location location) {
      dataSenseInfo.location = location;
      return this;
    }

    public Builder withInput(MetadataType input) {
      dataSenseInfo.input = input;
      return this;
    }

    public Builder withOutput(MetadataType output) {
      dataSenseInfo.output = output;
      return this;
    }

    public Builder withIncoming(MetadataType income) {
      dataSenseInfo.income = income;
      return this;
    }

    public Builder withExpected(MetadataType expected) {
      dataSenseInfo.expected = expected;
      return this;
    }

    public Builder withActualInput(MetadataType actualInput) {
      dataSenseInfo.actualInput = actualInput;
      return this;
    }

    public Builder withActualOutput(MetadataType actualOutput) {
      dataSenseInfo.actualOutput = actualOutput;
      return this;
    }

    public Builder withExpectedInput(MetadataType expectedInput) {
      dataSenseInfo.expectedInput = expectedInput;
      return this;
    }

    public Builder withExpectedOutput(MetadataType expectedOutput) {
      dataSenseInfo.expectedOutput = expectedOutput;
      return this;
    }

    public Builder withResult(MetadataType result) {
      dataSenseInfo.result = result;
      return this;
    }

    public Builder withOperationModel(OperationModel operationModel) {
      dataSenseInfo.operationModel = operationModel;
      return this;
    }

    public Builder withSourceModel(SourceModel sourceModel) {
      dataSenseInfo.sourceModel = sourceModel;
      return this;
    }

    public Builder withMessages(List<String> messages) {
      dataSenseInfo.messages = messages;
      return this;
    }

    public Builder withComponentInfoByComponentPath(Map<Location, DataSenseElementInfo> componentInfoByComponentPath) {
      dataSenseInfo.componentInfoByComponentPath = componentInfoByComponentPath;
      return this;
    }

    public Builder withNotifications(List<DataSenseNotification> notifications) {
      dataSenseInfo.notifications = notifications;
      return this;
    }

    public DataSenseInfo build() {
      return dataSenseInfo;
    }
  }

}
