/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.configuration.agent;

import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import org.mule.tooling.client.internal.configuration.agent.ImmutableAgentConfiguration;

public interface AgentConfiguration {
    public URL getToolingApiUrl();

    public int getDefaultConnectTimeout();

    public int getDefaultReadTimeout();

    public Optional<SSLContext> getSSLContext();

    public static AgentConfigurationBuilder newAgentConfigurationBuilder() {
        return new AgentConfigurationBuilder();
    }

    public static class AgentConfigurationBuilder {
        private URL toolingApiUrl;
        private int defaultConnectionTimeout = 0;
        private int defaultReadTimeout = 0;
        private SSLContext sslContext = null;

        public AgentConfigurationBuilder toolingApiUrl(URL toolingApiUrl) {
            Objects.requireNonNull(toolingApiUrl, "toolingApiUrl cannot be null");
            this.toolingApiUrl = toolingApiUrl;
            return this;
        }

        public AgentConfigurationBuilder defaultConnectionTimeout(int defaultConnectionTimeout) {
            AgentConfigurationBuilder.checkArgument(defaultConnectionTimeout >= 0, "defaultConnectionTimeout cannot be < 0");
            this.defaultConnectionTimeout = defaultConnectionTimeout;
            return this;
        }

        public AgentConfigurationBuilder defaultReadTimeout(int defaultReadTimeout) {
            AgentConfigurationBuilder.checkArgument(defaultReadTimeout >= 0, "defaultReadTimeout cannot be < 0");
            this.defaultReadTimeout = defaultReadTimeout;
            return this;
        }

        public AgentConfigurationBuilder sslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public AgentConfiguration build() {
            return new ImmutableAgentConfiguration(this.toolingApiUrl, this.defaultConnectionTimeout, this.defaultReadTimeout, this.sslContext);
        }

        protected static void checkArgument(boolean expression, Object errorMessage) {
            if (!expression) {
                throw new IllegalArgumentException(String.valueOf(errorMessage));
            }
        }
    }
}

