/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.metadata;

import org.mule.runtime.api.meta.model.ComponentModel;

/**
 * Represents the view of all Metadata associated to an Operation
 *
 * @since 1.0
 */
public final class ComponentMetadataDescriptor<T extends ComponentModel> {

  private final T model;
  private final MetadataAttributes metadataAttributes;

  public ComponentMetadataDescriptor(T model, MetadataAttributes metadataAttributes) {
    this.model = model;
    this.metadataAttributes = metadataAttributes;
  }

  public T getModel() {
    return model;
  }

  public MetadataAttributes getMetadataAttributes() {
    return metadataAttributes;
  }

}
