/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.extension.model.parameter;

import org.mule.tooling.client.api.types.UnknownType;

/**
 * Represents the possible roles that each parameter plays in the context of a {@link ParameterModel}.
 *
 * @since 1.0
 */
public class ParameterRole extends UnknownType {

  private boolean behaviour = false;
  private boolean content = false;
  private boolean primaryContent = false;

  // Just needed in order to serialize this object
  private ParameterRole() {}

  public ParameterRole(String value) {
    super(value);
  }

  public static ParameterRole behaviourParameterRole(String value) {
    ParameterRole parameterRole = new ParameterRole(value);
    parameterRole.behaviour = true;
    return parameterRole;
  }

  public static ParameterRole contentParameterRole(String value) {
    ParameterRole parameterRole = new ParameterRole(value);
    parameterRole.content = true;
    return parameterRole;
  }

  public static ParameterRole primaryContentParameterRole(String value) {
    ParameterRole parameterRole = new ParameterRole(value);
    parameterRole.primaryContent = true;
    return parameterRole;
  }

  /**
   * @return if {@code true}, indicates that the parameter is only configuring the component's behaviour and doesn't represent
   * data that is being sent to another endpoint
   */
  public boolean isBehaviour() {
    return behaviour;
  }

  /**
   * @return if {@code true}, indicates that this parameter holds information to be considered content to be sent to a different
   * system or endpoint. It makes sense to use this when the operation has many content parameters but
   * this one is not the {@link #isPrimaryContent}
   */
  public boolean isContent() {
    return content;
  }

  /**
   * @return if {@code true}, indicates that this parameter holds the main piece of content to be sent to another system or endpoint.
   * This differentiation becomes specially important when the component has many content parameters.
   *
   * If the component only has one content parameter, then this role will be used to mark such parameter
   */
  public boolean isPrimaryContent() {
    return primaryContent;
  }

}
