/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.extension.model.operation;

import org.mule.tooling.client.api.extension.model.DisplayModel;
import org.mule.tooling.client.api.extension.model.ErrorModel;
import org.mule.tooling.client.api.extension.model.OutputModel;
import org.mule.tooling.client.api.extension.model.Stereotype;
import org.mule.tooling.client.api.extension.model.parameter.ParameterGroupModel;

import java.util.List;
import java.util.Set;

/**
 * An specification which represents the particular case of a
 * router, such as choice, scatter-gather, first-successful, etc.
 * <p>
 * It adds a {@link #getRouteModels() list of routes} which describe the contained routes.
 *
 * @since 1.0
 */
public class RouterModel extends OperationModel {

  private List<RouteModel> routeModels;

  // Just needed in order to serialize this object
  private RouterModel() {}

  public RouterModel(String name, String description,
                     List<ParameterGroupModel> parameterGroupModels,
                     DisplayModel displayModel, boolean blocking,
                     Set<ErrorModel> errors,
                     OutputModel output,
                     OutputModel outputAttributes, boolean transaction,
                     boolean requiresConnection, boolean supportsStreaming,
                     Set<Stereotype> stereotypes, List<RouteModel> routeModels) {
    super(name, description, parameterGroupModels, displayModel, blocking, errors, output, outputAttributes, transaction,
          requiresConnection, supportsStreaming, stereotypes);
    this.routeModels = routeModels;
  }

  public List<RouteModel> getRouteModels() {
    return routeModels;
  }

}
