/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.extension.model;

import static org.apache.commons.lang3.StringUtils.isNotBlank;
import static org.mule.tooling.client.internal.util.Preconditions.checkState;

import java.util.Objects;

/**
 * A widely held but fixed and oversimplified image or idea of the owning model. Examples would be {@code validator},
 * {@code outbound}, etc.
 *
 * @since 1.0
 */
public class Stereotype {

  private String name;

  // Just needed in order to serialize this object
  private Stereotype() {}

  public Stereotype(String name) {
    checkState(isNotBlank(name), "name cannot be null");
    this.name = name;
  }

  public String getName() {
    return this.name;
  }

  public boolean equals(Object obj) {
    return obj instanceof Stereotype ? Objects.equals(this.name, ((Stereotype) obj).getName()) : false;
  }

  public int hashCode() {
    return this.name.hashCode();
  }

}
