/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.configuration.agent;

import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.mule.tooling.client.api.configuration.agent.AgentConfiguration;

public class ImmutableAgentConfiguration
implements AgentConfiguration {
    private Supplier<URL> toolingApiURLSupplier;
    private int defaultConnectionTimeout;
    private int defaultReadTimeout;
    private Optional<SSLContext> sslContext;

    public ImmutableAgentConfiguration(Supplier<URL> toolingApiURLSupplier, int defaultConnectionTimeout, int defaultReadTimeout, SSLContext sslContext) {
        Objects.requireNonNull(toolingApiURLSupplier, "toolingApiURLSupplier cannot be null");
        this.toolingApiURLSupplier = toolingApiURLSupplier;
        this.defaultConnectionTimeout = defaultConnectionTimeout;
        this.defaultReadTimeout = defaultReadTimeout;
        this.sslContext = Optional.ofNullable(sslContext);
    }

    @Override
    public Supplier<URL> getToolingApiURLSupplier() {
        return this.toolingApiURLSupplier;
    }

    @Override
    public int getDefaultConnectTimeout() {
        return this.defaultConnectionTimeout;
    }

    @Override
    public int getDefaultReadTimeout() {
        return this.defaultReadTimeout;
    }

    @Override
    public Optional<SSLContext> getSSLContext() {
        return this.sslContext;
    }

    public String toString() {
        return String.format("%s{defaultConnectionTimeout=%sms, defaultReadTimeout=%sms}", this.getClass().getName(), this.defaultConnectionTimeout, this.defaultReadTimeout);
    }
}

