/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.metadata.dto;

import java.util.Optional;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.mule.tooling.client.api.metadata.dto.FailureCode;
import org.mule.tooling.client.api.metadata.dto.MetadataComponent;
import org.mule.tooling.client.api.metadata.dto.MetadataResolvingException;

public final class MetadataFailure {
    private final MetadataComponent failingComponent;
    private final String failingElement;
    private final String message;
    private final String reason;
    private final FailureCode failureCode;

    public MetadataFailure(MetadataComponent failingComponent, String failingElement, String message, String reason, FailureCode failureCode) {
        this.failingComponent = failingComponent;
        this.failingElement = failingElement;
        this.message = message;
        this.reason = reason;
        this.failureCode = failureCode;
    }

    public MetadataComponent getFailingComponent() {
        return this.failingComponent;
    }

    public Optional<String> getFailingElement() {
        return Optional.ofNullable(this.failingElement);
    }

    public String getMessage() {
        return this.message;
    }

    public FailureCode getFailureCode() {
        return this.failureCode;
    }

    public String getReason() {
        return this.reason;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.JSON_STYLE);
    }

    public static class Builder {
        private String message;
        private String reason;
        private FailureCode code;

        private Builder() {
        }

        public static Builder newFailure() {
            return new Builder();
        }

        public static Builder newFailure(Exception e) {
            Builder builder = new Builder();
            builder.code = e instanceof MetadataResolvingException ? ((MetadataResolvingException)e).getFailure() : FailureCode.UNKNOWN;
            builder.message = e.getMessage();
            builder.reason = ExceptionUtils.getStackTrace((Throwable)e);
            return builder;
        }

        public MetadataFailure onKeys() {
            return this.build(new MetadataComponent(org.mule.runtime.api.metadata.resolving.MetadataComponent.KEYS.name(), false, false, false, false, false, false, true));
        }

        public MetadataFailure onComponent() {
            return this.build(new MetadataComponent(org.mule.runtime.api.metadata.resolving.MetadataComponent.COMPONENT.name(), false, false, false, false, true, false, false));
        }

        private MetadataFailure build(MetadataComponent failingPart) {
            return this.build(failingPart, null);
        }

        private MetadataFailure build(MetadataComponent failingPart, String failureComponent) {
            return new MetadataFailure(failingPart, failureComponent, this.message, this.reason, this.code);
        }

        public Builder withMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder withReason(String reason) {
            this.reason = reason;
            return this;
        }

        public Builder withFailureCode(FailureCode failureCode) {
            this.code = failureCode;
            return this;
        }
    }
}

