/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.metadata.dto;

import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.util.Preconditions;
import org.mule.tooling.client.api.metadata.dto.MetadataKey;

public final class MetadataAttributes {
    private final MetadataKey key;
    private final String category;
    private final Map<String, String> parameters;
    private final String outputResolver;
    private final String attributesResolver;

    public MetadataAttributes(MetadataKey key, String category, Map<String, String> parameters, String outputResolver, String attributesResolver) {
        this.key = key;
        this.category = category;
        this.parameters = parameters;
        this.outputResolver = outputResolver;
        this.attributesResolver = attributesResolver;
    }

    public Optional<MetadataKey> getKey() {
        return Optional.ofNullable(this.key);
    }

    public String getParameterResolverName(String parameterName) {
        Preconditions.checkArgument((boolean)this.parameters.containsKey(parameterName), (String)"Parameter named %s is not associated to a resolver");
        return this.parameters.get(parameterName);
    }

    public String getCategoryName() {
        return this.category;
    }

    public Optional<String> getOutputResolverName() {
        return Optional.ofNullable(this.outputResolver);
    }

    public Optional<String> getOutputAttributesResolverName() {
        return Optional.ofNullable(this.attributesResolver);
    }
}

