/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.el;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.mule.tooling.client.api.el.ValidationMessage;

public class ValidationResult {
    private boolean result;
    private String errorMessage;
    private List<ValidationMessage> messages;

    public static ValidationResult success() {
        return new ValidationResult(true, null);
    }

    public static ValidationResult failure(String message) {
        return new ValidationResult(false, message);
    }

    public static ValidationResult failure(String message, List<ValidationMessage> messages) {
        return new ValidationResult(false, message, messages);
    }

    public static ValidationResult failure(String message, String expression) {
        return ValidationResult.failure(String.format("%s. Offending expression string is: %s", message, expression));
    }

    public ValidationResult() {
    }

    public ValidationResult(boolean result, String errorMessage) {
        this(result, errorMessage, Collections.emptyList());
    }

    public ValidationResult(boolean result, String errorMessage, List<ValidationMessage> messages) {
        this.result = result;
        this.errorMessage = errorMessage;
        this.messages = Collections.unmodifiableList(messages);
    }

    public Optional<String> errorMessage() {
        return Optional.ofNullable(this.errorMessage);
    }

    public List<ValidationMessage> messages() {
        return this.messages;
    }

    public boolean isSuccess() {
        return this.result;
    }
}

