/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.artifact;

import org.mule.tooling.client.api.Disposable;
import org.mule.tooling.client.api.connectivity.ConnectivityTestingService;
import org.mule.tooling.client.api.datasense.DataSenseService;
import org.mule.tooling.client.api.dataweave.DataWeaveService;
import org.mule.tooling.client.api.metadata.MetadataService;

/**
 * Provides tooling operations for a Mule Artifact.
 *
 * @since 1.0
 */
public interface ToolingArtifact extends Disposable {

  /**
   * Calling this method will trigger the application to be deployed. Deployment of the application is handled internally
   * to be triggered only if needed when a service has to resolve an operation that requires the application to be deployed
   * on Mule Runtime.
   *
   * @return the identifier for the application once it is deployed.
   */
  String getApplicationId();

  /**
   * Returns a {@link ConnectivityTestingService} to allow testing connections over the {@link ToolingArtifact} configuration.
   *
   * @return a {@link ConnectivityTestingService}
   */
  ConnectivityTestingService connectivityTestingService();

  /**
   * Returns a {@link MetadataService} to allow retrieving metadata over the {@link ToolingArtifact} configuration elements.
   *
   * @return a {@link MetadataService}
   */
  MetadataService metadataService();

  /**
   * Returns a {@link DataSenseService} to resolve data sense operations over the {@link ToolingArtifact}.
   *
   * @return a {@link DataSenseService}
   */
  DataSenseService dataSenseService();

  /**
   * Returns a {@link DataWeaveService} to run a DataWeave script over an application context.
   *
   * @return a {@link DataWeaveService}
   */
  DataWeaveService dataweaveService();
}
