/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.configuration.agent;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.mule.tooling.client.internal.configuration.agent.ImmutableAgentConfiguration;

public interface AgentConfiguration {
    public Supplier<URL> getToolingApiURLSupplier();

    public int getDefaultConnectTimeout();

    public int getDefaultReadTimeout();

    public Optional<SSLContext> getSSLContext();

    public static AgentConfigurationBuilder newAgentConfigurationBuilder() {
        return new AgentConfigurationBuilder();
    }

    public static class AgentConfigurationBuilder {
        private Supplier<URL> toolingApiURLSupplier;
        private int defaultConnectionTimeout = 0;
        private int defaultReadTimeout = 0;
        private SSLContext sslContext = null;

        public AgentConfigurationBuilder withToolingApiURLSupplier(Supplier<String> toolingApiURLSupplier) {
            Objects.requireNonNull(toolingApiURLSupplier, "toolingApiURLSupplier cannot be null");
            this.toolingApiURLSupplier = () -> {
                String url = (String)toolingApiURLSupplier.get();
                try {
                    return new URL(url);
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException("Couldn't create URL from: " + url, e);
                }
            };
            return this;
        }

        public AgentConfigurationBuilder withDefaultConnectionTimeout(int defaultConnectionTimeout) {
            AgentConfigurationBuilder.checkArgument(defaultConnectionTimeout >= 0, "defaultConnectionTimeout cannot be < 0");
            this.defaultConnectionTimeout = defaultConnectionTimeout;
            return this;
        }

        public AgentConfigurationBuilder withDefaultReadTimeout(int defaultReadTimeout) {
            AgentConfigurationBuilder.checkArgument(defaultReadTimeout >= 0, "defaultReadTimeout cannot be < 0");
            this.defaultReadTimeout = defaultReadTimeout;
            return this;
        }

        public AgentConfigurationBuilder withSslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public AgentConfiguration build() {
            return new ImmutableAgentConfiguration(this.toolingApiURLSupplier, this.defaultConnectionTimeout, this.defaultReadTimeout, this.sslContext);
        }

        protected static void checkArgument(boolean expression, Object errorMessage) {
            if (!expression) {
                throw new IllegalArgumentException(String.valueOf(errorMessage));
            }
        }
    }
}

