/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.datasense;

import org.mule.datasense.api.ComponentResolutionScope;
import org.mule.datasense.api.DataSenseResolutionScope;
import org.mule.runtime.api.component.location.Location;
import org.mule.tooling.client.api.artifact.ToolingArtifact;

import static java.util.Objects.requireNonNull;

/**
 * Resolve specific request for {@link DataSenseService}.
 *
 * @since 1.0
 */
public class DataSenseResolveRequest extends DataSenseRequest {

  private DataSenseResolutionScope dataSenseResolutionScope;

  /**
   * Sets the location from the {@link ToolingArtifact} configuration to be used for resolving DataSense.
   *
   * @param location from the {@link ToolingArtifact} configuration.
   */
  public void setLocation(Location location) {
    requireNonNull(location, "location cannot null");
    setDataSenseResolutionScope(new ComponentResolutionScope(location));
  }

  /**
   * @return the componentPath from the {@link ToolingArtifact} configuration.
   */
  public Location getLocation() {
    final DataSenseResolutionScope dataSenseResolutionScope = getDataSenseResolutionScope();
    if (dataSenseResolutionScope instanceof ComponentResolutionScope) {
      return ((ComponentResolutionScope) dataSenseResolutionScope).getLocation();
    } else {
      return null;
    }
  }

  /**
   * Sets the resolution scope to be used on resolving DataSense.
   *
   * @param dataSenseResolutionScope resolution scope to use.
   */
  public void setDataSenseResolutionScope(DataSenseResolutionScope dataSenseResolutionScope) {
    requireNonNull(dataSenseResolutionScope, "dataSenseResolutionScope cannot null");
    this.dataSenseResolutionScope = dataSenseResolutionScope;
  }

  /**
   * @return the {@link DataSenseResolutionScope}.
   */
  public DataSenseResolutionScope getDataSenseResolutionScope() {
    return dataSenseResolutionScope;
  }
}
