/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime.process.controller;

import java.io.File;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.mule.tooling.runtime.process.controller.MuleProcessController;
import org.mule.tooling.runtime.process.controller.MuleServiceWrapper;
import org.mule.tooling.runtime.process.controller.command.ConsoleMuleCommand;
import org.mule.tooling.runtime.process.controller.exception.MuleProcessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.exec.StartedProcess;
import org.zeroturnaround.process.PidProcess;
import org.zeroturnaround.process.ProcessUtil;
import org.zeroturnaround.process.Processes;
import org.zeroturnaround.process.SystemProcess;

public abstract class AbstractMuleProcessController
implements MuleProcessController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final MuleServiceWrapper muleServiceWrapper;
    private StartedProcess consoleProcess;
    private PidProcess wrapperProcess;
    private Thread shutdownHook;

    AbstractMuleProcessController(File muleHome, long timeout, String muleBinary) {
        File bin = new File(new File(muleHome, "bin"), muleBinary);
        this.checkState(bin.exists(), muleBinary + " not present");
        this.checkState(bin.canExecute(), muleBinary + " cannot be executed");
        this.muleServiceWrapper = new MuleServiceWrapper(muleHome, timeout, muleBinary);
    }

    private void checkState(boolean condition, String errorMessage) {
        if (!condition) {
            throw new IllegalStateException(errorMessage);
        }
    }

    protected MuleServiceWrapper getMuleServiceWrapper() {
        return this.muleServiceWrapper;
    }

    @Override
    public void start(String[] args) throws MuleProcessException {
        int pid;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Starting Mule Runtime from: {}", (Object)this.muleServiceWrapper.getMuleHome().getAbsolutePath());
        }
        this.shutdownHook = new Thread(() -> this.stop());
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        ConsoleMuleCommand consoleCommand = new ConsoleMuleCommand(this.muleServiceWrapper, args);
        consoleCommand.execute();
        this.consoleProcess = consoleCommand.getProcess();
        Awaitility.with().timeout(this.muleServiceWrapper.getProcessInvocationTimeout().longValue(), TimeUnit.MILLISECONDS).pollInterval(500L, TimeUnit.MILLISECONDS).pollDelay(250L, TimeUnit.MILLISECONDS).until(() -> this.getPID() != -1);
        try {
            pid = this.getPID();
        }
        catch (Exception e) {
            this.stopQuietly();
            throw new MuleProcessException("Error while getting PID for wrapper process", e);
        }
        if (pid == -1) {
            this.stopQuietly();
            throw new MuleProcessException("Could not get PID for wrapper");
        }
        this.wrapperProcess = Processes.newPidProcess((int)pid);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Wrapper process PID: {}", (Object)this.wrapperProcess.getPid());
        }
    }

    protected abstract int getPID() throws Exception;

    private void stopQuietly() {
        try {
            this.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isRunning() throws MuleProcessException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Checking if Mule Runtime is running");
        }
        try {
            return this.wrapperProcess != null ? this.wrapperProcess.isAlive() : false;
        }
        catch (Exception e) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Error while checking status", (Throwable)e);
            }
            return false;
        }
    }

    @Override
    public void stop() throws MuleProcessException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Stopping Mule Runtime");
        }
        if (this.wrapperProcess != null) {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Destroying service wrapper process");
                }
                ProcessUtil.destroyGracefullyOrForcefullyAndWait((SystemProcess)this.wrapperProcess);
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            catch (Exception e) {
                throw new MuleProcessException(e);
            }
            finally {
                this.consoleProcess.getProcess().destroy();
            }
        }
    }
}

