/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.runtime.process.controller;

import org.mule.tooling.runtime.process.controller.exception.MuleProcessException;

/**
 * Process controller for Mule Runtime to operate a Mule Runtime instance.
 *
 * @since 4.0
 */
public interface MuleProcessController {

  /**
   * Starts Mule Runtime.
   *
   * @param args array of {@link String} arguments to be passed to Mule Runtime when started. They have to be in format
   * 
   *             <pre>
   * -M-DmySystemProperty=value
   *             </pre>
   * 
   *             or
   * 
   *             <pre>
   * -Wwrapper.property=value
   *             </pre>
   * 
   * @throws MuleProcessException if there was an error while starting it.
   */
  void start(String[] args) throws MuleProcessException;

  /**
   * @return {@code true} if Mule Runtime is up and running.
   * @throws MuleProcessException if there was an error while checking the state.
   */
  boolean isRunning() throws MuleProcessException;

  /**
   * Stops Mule Runtime.
   *
   * @throws MuleProcessException if there was an error while stopping it.
   */
  void stop() throws MuleProcessException;

}
