/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime.process.controller.command;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.mule.tooling.runtime.process.controller.MuleServiceWrapper;
import org.mule.tooling.runtime.process.controller.command.MuleCommand;
import org.mule.tooling.runtime.process.controller.exception.MuleProcessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.stream.slf4j.Slf4jStream;

public abstract class AbstractMuleCommand
implements MuleCommand {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private MuleServiceWrapper muleServiceWrapper;

    public AbstractMuleCommand(MuleServiceWrapper muleServiceWrapper) {
        Objects.requireNonNull(muleServiceWrapper, "muleServiceWrapper cannot be null");
        this.muleServiceWrapper = muleServiceWrapper;
    }

    protected MuleServiceWrapper getMuleServiceWrapper() {
        return this.muleServiceWrapper;
    }

    protected ProcessExecutor createMuleProcessExecutor(String command) {
        return this.createMuleProcessExecutor(Collections.singletonList(command));
    }

    protected ProcessExecutor createMuleProcessExecutor(String command, String[] args) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(command);
        commands.addAll(Arrays.asList(args));
        return this.createMuleProcessExecutor(commands);
    }

    protected ProcessExecutor createMuleProcessExecutor(List<String> command) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.getMuleServiceWrapper().getMuleBinaryCommand());
        commands.addAll(command);
        return new ProcessExecutor().commandSplit(String.join((CharSequence)" ", commands)).redirectError((OutputStream)Slf4jStream.of((Logger)this.logger).asError()).redirectOutput((OutputStream)Slf4jStream.of((Logger)this.logger).asDebug()).timeout(this.getMuleServiceWrapper().getProcessInvocationTimeout().longValue(), TimeUnit.MILLISECONDS).environment("MULE_HOME", this.getMuleServiceWrapper().getMuleHome().getAbsolutePath());
    }

    @Override
    public final void execute() {
        try {
            this.doExecute();
        }
        catch (Exception e) {
            throw new MuleProcessException("Error while executing command", e);
        }
    }

    protected static void checkState(boolean condition, String errorMessage) {
        if (!condition) {
            throw new IllegalStateException(errorMessage);
        }
    }

    protected abstract void doExecute() throws Exception;
}

