/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime.process.controller;

import java.io.File;
import java.util.Objects;

public class MuleServiceWrapper {
    public static final String MULE_HOME = "MULE_HOME";
    private static final String BIN_FOLDER = "bin";
    private final File muleHome;
    private final Long timeout;
    private String muleBinary;

    MuleServiceWrapper(File muleHome, long timeout, String muleBinaryCommand) {
        Objects.requireNonNull(muleHome, "muleHome cannot be null");
        this.muleHome = muleHome;
        this.muleBinary = muleHome + File.separator + BIN_FOLDER + File.separator + muleBinaryCommand;
        this.timeout = timeout;
        if (!muleHome.exists() || !muleHome.isDirectory()) {
            throw new IllegalStateException("muleHome directory is not referencing to a valid Mule Runtime directory structure");
        }
    }

    public String getMuleBinaryCommand() {
        return this.muleBinary;
    }

    public Long getProcessInvocationTimeout() {
        return this.timeout;
    }

    public File getMuleHome() {
        return this.muleHome;
    }
}

