/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime.process.controller;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mule.tooling.runtime.process.controller.AbstractMuleProcessController;
import org.mule.tooling.runtime.process.controller.command.StatusMuleCommand;

class UnixMuleProcessController
extends AbstractMuleProcessController {
    private static final String MULE_UNIX_BINARY = "mule";
    private static final String STATUS = "Mule Enterprise Edition is running \\(([0-9]+)\\)\\.";
    private static final Pattern STATUS_PATTERN = Pattern.compile("Mule Enterprise Edition is running \\(([0-9]+)\\)\\.");

    UnixMuleProcessController(File muleHome, long timeout) {
        super(muleHome, timeout, MULE_UNIX_BINARY);
    }

    @Override
    protected int getPID() throws Exception {
        StatusMuleCommand command = new StatusMuleCommand(this.getMuleServiceWrapper());
        command.execute();
        Matcher matcher = STATUS_PATTERN.matcher(command.getProcessOutput().getString());
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(1));
        }
        return -1;
    }
}

