/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.event.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.mule.tooling.event.model.ErrorModel;
import org.mule.tooling.event.model.MessageModel;
import org.mule.tooling.event.model.TypedValueModel;

public class EventModel {
    private MessageModel message;
    private Map<String, TypedValueModel> variables = new HashMap<String, TypedValueModel>();
    private ErrorModel error;
    private boolean successful;

    public EventModel() {
    }

    private EventModel(MessageModel message, Map<String, TypedValueModel> variables, ErrorModel error, boolean isSuccessful) {
        Objects.requireNonNull(message, "message cannot be null");
        this.message = message;
        this.variables = variables;
        this.error = error;
        this.successful = isSuccessful;
    }

    public MessageModel getMessage() {
        return this.message;
    }

    public Map<String, TypedValueModel> getVariables() {
        return this.variables;
    }

    public ErrorModel getError() {
        return this.error;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public void setSuccessful(boolean successful) {
        this.successful = successful;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventModel that = (EventModel)o;
        if (!this.message.equals(that.message)) {
            return false;
        }
        if (this.variables != null ? !this.variables.equals(that.variables) : that.variables != null) {
            return false;
        }
        return this.error != null ? this.error.equals(that.error) : that.error == null;
    }

    public int hashCode() {
        int result = this.message.hashCode();
        result = 31 * result + (this.variables != null ? this.variables.hashCode() : 0);
        result = 31 * result + (this.error != null ? this.error.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private MessageModel message;
        private Map<String, TypedValueModel> variables;
        private ErrorModel error;
        private boolean isSuccessful = true;

        private Builder() {
        }

        public Builder withMessage(MessageModel message) {
            this.message = message;
            return this;
        }

        public Builder withVariables(Map<String, TypedValueModel> variables) {
            this.variables = variables;
            return this;
        }

        public Builder withError(ErrorModel error) {
            return this.withError(error, false);
        }

        public Builder withError(ErrorModel error, boolean markSuccessfull) {
            this.error = error;
            this.isSuccessful = !markSuccessfull || error == null;
            return this;
        }

        public EventModel build() {
            return new EventModel(this.message, this.variables, this.error, this.isSuccessful);
        }
    }
}

