/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.event.model;

import java.util.Arrays;
import java.util.Objects;
import org.mule.tooling.event.model.DataTypeModel;

public class TypedValueModel {
    private DataTypeModel dataType;
    private byte[] content;
    private boolean truncated;
    private boolean error;
    private String exceptionMessage;
    private String[] exceptionStacktrace;

    public TypedValueModel() {
    }

    private TypedValueModel(DataTypeModel dataType, byte[] content, boolean truncated, boolean error, String exceptionMessage, String[] exceptionStacktrace) {
        Objects.requireNonNull(dataType, "dataType cannot be null");
        this.dataType = dataType;
        this.content = content;
        this.truncated = truncated;
        this.error = error;
        this.exceptionMessage = exceptionMessage;
        this.exceptionStacktrace = exceptionStacktrace;
    }

    public DataTypeModel getDataType() {
        return this.dataType;
    }

    public byte[] getContent() {
        return this.content;
    }

    public boolean isError() {
        return this.error;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public String[] getExceptionStacktrace() {
        return this.exceptionStacktrace;
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypedValueModel that = (TypedValueModel)o;
        if (this.truncated != that.truncated) {
            return false;
        }
        if (!this.dataType.equals(that.dataType)) {
            return false;
        }
        return Arrays.equals(this.content, that.content);
    }

    public static Builder builder() {
        return new Builder();
    }

    public int hashCode() {
        int result = this.dataType.hashCode();
        result = 31 * result + Arrays.hashCode(this.content);
        result = 31 * result + (this.truncated ? 1 : 0);
        return result;
    }

    public static class Builder {
        private DataTypeModel dataType;
        private byte[] content;
        private boolean truncated = false;
        private boolean error;
        private String exceptionMessage;
        private String[] exceptionStackTrace;

        private Builder() {
        }

        public Builder withDataType(DataTypeModel dataTypeModel) {
            this.dataType = dataTypeModel;
            return this;
        }

        public Builder withContent(byte[] content) {
            this.content = content;
            return this;
        }

        public Builder withTruncated(boolean truncated) {
            this.truncated = truncated;
            return this;
        }

        public Builder withError(boolean error) {
            this.error = error;
            return this;
        }

        public Builder withExceptionMessage(String exceptionMessage) {
            this.exceptionMessage = exceptionMessage;
            return this;
        }

        public Builder withExceptionStackTrace(String[] exceptionStackTrace) {
            this.exceptionStackTrace = exceptionStackTrace;
            return this;
        }

        public TypedValueModel build() {
            return new TypedValueModel(this.dataType, this.content, this.truncated, this.error, this.exceptionMessage, this.exceptionStackTrace);
        }
    }
}

