/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.event.model;

import java.util.Objects;
import org.mule.tooling.event.model.ModelType;

public class DataTypeModel {
    private String type;
    private String mediaType;
    @Deprecated
    private ModelType modelType;

    public DataTypeModel() {
    }

    protected DataTypeModel(String type, String mediaType, ModelType modelType) {
        Objects.requireNonNull(type, "type cannot be null");
        Objects.requireNonNull(mediaType, "mediaType cannot be null");
        Objects.requireNonNull(modelType, "modelType cannot be null");
        this.type = type;
        this.mediaType = mediaType;
        this.modelType = modelType;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public String getType() {
        return this.type;
    }

    public ModelType getModelType() {
        return this.modelType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataTypeModel that = (DataTypeModel)o;
        if (!this.type.equals(that.type)) {
            return false;
        }
        if (!this.modelType.equals(that.modelType)) {
            return false;
        }
        return this.mediaType.equals(that.mediaType);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.mediaType.hashCode();
        return result;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String type;
        private String mediaType;
        private ModelType modelType = ModelType.simpleModelType();

        private Builder() {
        }

        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        public Builder withMediaType(String mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        public Builder asCollectionWithItemsType(String itemsType) {
            this.modelType = ModelType.collectionModelType(itemsType);
            return this;
        }

        public DataTypeModel build() {
            return new DataTypeModel(this.type, this.mediaType, this.modelType);
        }
    }
}

