/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.event.model;

public class ModelType {

  private String itemsType;
  private boolean collection;

  public ModelType() {}

  public ModelType(boolean collection, String itemsType) {
    this.itemsType = itemsType;
    this.collection = collection;
  }

  public static ModelType collectionModelType(String itemsType) {
    return new ModelType(true, itemsType);
  }

  public static ModelType simpleModelType() {
    return new ModelType(false, null);
  }

  public boolean isCollection() {
    return this.collection;
  }

  public String getItemsType() {
    return this.itemsType;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    ModelType that = (ModelType) o;
    if (this.collection != that.collection) {
      return false;
    }

    return this.itemsType.equals(that.itemsType);
  }
}
