/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.event.model;

import static java.util.Objects.requireNonNull;

public class DataTypeModel {

  private String type;
  private String mediaType;

  // Used by json serializer/deserialzer
  public DataTypeModel() {}

  private DataTypeModel(String type, String mediaType) {
    requireNonNull(type, "type cannot be null");
    requireNonNull(mediaType, "mediaType cannot be null");

    this.type = type;
    this.mediaType = mediaType;
  }

  public String getMediaType() {
    return mediaType;
  }

  public String getType() {
    return type;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    DataTypeModel that = (DataTypeModel) o;

    if (!type.equals(that.type)) {
      return false;
    }
    return mediaType.equals(that.mediaType);
  }

  @Override
  public int hashCode() {
    int result = type.hashCode();
    result = 31 * result + mediaType.hashCode();
    return result;
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {

    private String type;
    private String mediaType;

    private Builder() {}

    public Builder withType(String type) {
      this.type = type;
      return this;
    }

    public Builder withMediaType(String mediaType) {
      this.mediaType = mediaType;
      return this;
    }

    public DataTypeModel build() {
      return new DataTypeModel(this.type, this.mediaType);
    }

  }

}
