/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.event.model;

import java.util.Objects;

public class DataTypeModel {
    private String type;
    private String mediaType;

    public DataTypeModel() {
    }

    private DataTypeModel(String type, String mediaType) {
        Objects.requireNonNull(type, "type cannot be null");
        Objects.requireNonNull(mediaType, "mediaType cannot be null");
        this.type = type;
        this.mediaType = mediaType;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public String getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataTypeModel that = (DataTypeModel)o;
        if (!this.type.equals(that.type)) {
            return false;
        }
        return this.mediaType.equals(that.mediaType);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.mediaType.hashCode();
        return result;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String type;
        private String mediaType;

        private Builder() {
        }

        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        public Builder withMediaType(String mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        public DataTypeModel build() {
            return new DataTypeModel(this.type, this.mediaType);
        }
    }
}

