/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.event.model;

public class ErrorModel {

  private String description;
  private String detailedDescription;
  private String type;
  private String exceptionType;
  private MessageModel message;

  // Used by json serializer/deserialzer
  public ErrorModel() {}

  private ErrorModel(String description, String detailedDescription, String type, MessageModel message, String exceptionType) {
    this.description = description;
    this.detailedDescription = detailedDescription;
    this.type = type;
    this.message = message;
    this.exceptionType = exceptionType;
  }

  public String getDescription() {
    return description;
  }

  public String getDetailedDescription() {
    return detailedDescription;
  }

  public String getType() {
    return type;
  }

  public MessageModel getMessage() {
    return message;
  }

  public String getExceptionType() {
    return exceptionType;
  }

  public static Builder builder() {
    return new Builder();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    ErrorModel that = (ErrorModel) o;

    if (!description.equals(that.description)) {
      return false;
    }
    if (!detailedDescription.equals(that.detailedDescription)) {
      return false;
    }
    if (!type.equals(that.type)) {
      return false;
    }
    if (!exceptionType.equals(that.exceptionType)) {
      return false;
    }
    return message != null ? message.equals(that.message) : that.message == null;
  }

  @Override
  public int hashCode() {
    int result = description.hashCode();
    result = 31 * result + detailedDescription.hashCode();
    result = 31 * result + type.hashCode();
    result = 31 * result + exceptionType.hashCode();
    result = 31 * result + (message != null ? message.hashCode() : 0);
    return result;
  }

  public static class Builder {

    private String description;
    private String detailedDescription;
    private String type;
    private String exceptionType;
    private MessageModel message;

    private Builder() {}

    public Builder withDescription(String description) {
      this.description = description;
      return this;
    }

    public Builder withDetailedDescription(String detailedDescription) {
      this.detailedDescription = detailedDescription;
      return this;
    }

    public Builder withType(String type) {
      this.type = type;
      return this;
    }

    public Builder withMessage(MessageModel message) {
      this.message = message;
      return this;
    }

    public Builder withExceptionType(String exceptionType) {
      this.exceptionType = exceptionType;
      return this;
    }

    public ErrorModel build() {
      return new ErrorModel(this.description, this.detailedDescription, this.type, this.message, this.exceptionType);
    }

  }

}
