/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.agent.rest.client.tooling.applications.applicationName.messageHistory;

import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.mule.tooling.agent.rest.client.exceptions.ToolingAgentHandlerException;
import org.mule.tooling.agent.rest.client.tooling.applications.applicationName.messageHistory.AgentTrackingNotificationResponse;

public class MessageHistory {
    private static String CHUNK_SIZE_PARAM = "chunkSize";
    private String baseUrl;
    private Client client;

    public MessageHistory(String baseUrl, Client client) {
        this.baseUrl = baseUrl + "/messagehistory";
        this.client = client;
    }

    private Client getClient() {
        return this.client;
    }

    private String getBaseUri() {
        return this.baseUrl;
    }

    public List<AgentTrackingNotificationResponse> get(int chunkSize, boolean verboseErrorsEnabled, int readTimeout) throws ToolingAgentHandlerException {
        Response response;
        WebTarget target = this.getClient().target(this.getBaseUri());
        target = target.queryParam(CHUNK_SIZE_PARAM, new Object[]{chunkSize});
        target = target.queryParam("verbose", new Object[]{verboseErrorsEnabled});
        Invocation.Builder invocationBuilder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        if (readTimeout > 0) {
            invocationBuilder.property("jersey.config.client.readTimeout", (Object)readTimeout);
        }
        if ((response = invocationBuilder.get()).getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            throw ToolingAgentHandlerException.newToolingAgentHandlerException(response);
        }
        return (List)response.readEntity((GenericType)new GenericType<List<AgentTrackingNotificationResponse>>(){});
    }

    public void put(boolean verboseErrorsEnabled, int readTimeout) throws ToolingAgentHandlerException {
        Response response;
        WebTarget target = this.getClient().target(this.getBaseUri());
        target = target.queryParam("verbose", new Object[]{verboseErrorsEnabled});
        Invocation.Builder invocationBuilder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        if (readTimeout > 0) {
            invocationBuilder.property("jersey.config.client.readTimeout", (Object)readTimeout);
        }
        if ((response = invocationBuilder.put(Entity.json((Object)""))).getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            throw ToolingAgentHandlerException.newToolingAgentHandlerException(response);
        }
    }

    public void delete(boolean verboseErrorsEnabled, int readTimeout) throws ToolingAgentHandlerException {
        Response response;
        WebTarget target = this.getClient().target(this.getBaseUri());
        target = target.queryParam("verbose", new Object[]{verboseErrorsEnabled});
        Invocation.Builder invocationBuilder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        if (readTimeout > 0) {
            invocationBuilder.property("jersey.config.client.readTimeout", (Object)readTimeout);
        }
        if ((response = invocationBuilder.delete()).getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            throw ToolingAgentHandlerException.newToolingAgentHandlerException(response);
        }
    }
}

