/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.agent.rest.client.api;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URLConnection;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import jersey.repackaged.com.google.common.base.Preconditions;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.HttpUrlConnectorProvider;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.mule.tooling.agent.rest.client.filter.AuthorizationRequestFilter;
import org.mule.tooling.agent.rest.client.tooling.Tooling;
import org.mule.tooling.client.api.configuration.agent.proxy.ProxyConfig;

public class ToolingServiceAPIClient {
    public final Tooling tooling;

    private ToolingServiceAPIClient(String toolingApiUrl, int defaultConnectTimeout, int defaultReadTimeout, Optional<SSLContext> sslContext, Optional<ProxyConfig> proxyConfig, String authorizationToken) {
        Preconditions.checkNotNull((Object)toolingApiUrl, (Object)"baseUrl cannot be null");
        this.tooling = new Tooling(toolingApiUrl, this.newClient(defaultConnectTimeout, defaultReadTimeout, sslContext, proxyConfig, authorizationToken));
    }

    private Client newClient(int connectTimeout, int readTimeout, Optional<SSLContext> sslContextOptional, Optional<ProxyConfig> proxyConfig, String authorizationToken) {
        ClientConfig configuration = new ClientConfig(new Object[]{new JacksonJaxbJsonProvider().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)});
        configuration.property("jersey.config.client.connectTimeout", (Object)connectTimeout);
        configuration.property("jersey.config.client.readTimeout", (Object)readTimeout);
        if (proxyConfig.isPresent()) {
            ProxyConfig proxyConfiguration = proxyConfig.get();
            String proxyUri = "http://" + proxyConfiguration.getHost();
            if (proxyConfiguration.getPort() != null) {
                proxyUri = proxyUri + ":" + proxyConfiguration.getPort();
            }
            configuration.property("jersey.config.client.proxy.uri", (Object)proxyUri);
        }
        HttpUrlConnectorProvider connectorProvider = new HttpUrlConnectorProvider();
        connectorProvider.connectionFactory(url -> {
            Proxy proxy = Proxy.NO_PROXY;
            if (proxyConfig.isPresent()) {
                proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(((ProxyConfig)proxyConfig.get()).getHost(), (int)((ProxyConfig)proxyConfig.get()).getPort()));
            }
            URLConnection urlConnection = url.openConnection(proxy);
            return (HttpURLConnection)urlConnection;
        });
        configuration.connectorProvider((ConnectorProvider)connectorProvider);
        ClientBuilder builder = ClientBuilder.newBuilder();
        configuration.register((Object)new AuthorizationRequestFilter(authorizationToken));
        builder.withConfig((Configuration)configuration);
        sslContextOptional.ifPresent(sslContext -> builder.sslContext(sslContext));
        return builder.build();
    }

    public static ToolingServiceAPIClient create(String baseUrl, int defaultConnectTimeout, int defaultReadTimeout, Optional<SSLContext> sslContext, Optional<ProxyConfig> proxyConfig, String authorizationToken) {
        return new ToolingServiceAPIClient(baseUrl, defaultConnectTimeout, defaultReadTimeout, sslContext, proxyConfig, authorizationToken);
    }
}

