
/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.agent.rest.client.tooling.domains.model;

import static org.apache.commons.lang3.builder.ToStringBuilder.reflectionToString;

import java.util.HashMap;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

/**
 * Deploy domain request
 *
 * @since 4.0
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "domainLocation"
})
public class DomainsPUTBody {

  @JsonProperty("id")
  @JsonPropertyDescription("")
  private String id;
  /**
   * Path to the domain content
   */
  @JsonProperty("domainLocation")
  @JsonPropertyDescription("")
  private String domainLocation;
  @JsonProperty("content")
  @JsonPropertyDescription("")
  private byte[] content;
  @JsonProperty("deploymentProperties")
  @JsonPropertyDescription("")
  private Map<String, String> deploymentProperties;
  @JsonIgnore
  private Map<String, Object> additionalProperties = new HashMap<String, Object>();

  /**
   * No args constructor for use in serialization
   */
  public DomainsPUTBody() {}

  @JsonProperty("id")
  public String getId() {
    return id;
  }

  @JsonProperty("id")
  public void setId(String id) {
    this.id = id;
  }

  public DomainsPUTBody withId(String id) {
    this.id = id;
    return this;
  }

  @JsonProperty("domainLocation")
  public String getDomainLocation() {
    return domainLocation;
  }

  @JsonProperty("domainLocation")
  public void setDomainLocation(String domainLocation) {
    this.domainLocation = domainLocation;
  }

  public DomainsPUTBody withDomainLocation(String domainLocation) {
    this.domainLocation = domainLocation;
    return this;
  }

  public byte[] getContent() {
    return content;
  }

  public void setContent(byte[] content) {
    this.content = content;
  }

  public DomainsPUTBody withContent(byte[] content) {
    this.content = content;
    return this;
  }

  public Map<String, String> getDeploymentProperties() {
    return deploymentProperties;
  }

  public void setDeploymentProperties(Map<String, String> deploymentProperties) {
    this.deploymentProperties = deploymentProperties;
  }

  public DomainsPUTBody withDeploymentProperties(Map<String, String> deploymentProperties) {
    this.deploymentProperties = deploymentProperties;
    return this;
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  @JsonAnySetter
  public void setAdditionalProperty(String name, Object value) {
    this.additionalProperties.put(name, value);
  }

  public DomainsPUTBody withAdditionalProperty(String name, Object value) {
    this.additionalProperties.put(name, value);
    return this;
  }

  @Override
  public boolean equals(Object other) {
    if (other == this) {
      return true;
    }
    if ((other instanceof DomainsPUTBody) == false) {
      return false;
    }
    DomainsPUTBody rhs = ((DomainsPUTBody) other);
    return new EqualsBuilder()
        .append(id, rhs.id)
        .append(domainLocation, rhs.domainLocation)
        .append(content, rhs.content)
        .append(deploymentProperties, rhs.deploymentProperties)
        .append(additionalProperties, rhs.additionalProperties)
        .isEquals();
  }

  @Override
  public int hashCode() {
    return new HashCodeBuilder()
        .append(id)
        .append(domainLocation)
        .append(content)
        .append(deploymentProperties)
        .append(additionalProperties)
        .toHashCode();
  }

  @Override
  public String toString() {
    return reflectionToString(this);
  }

}
