
/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.agent.rest.client.tooling.domains.model;

import static org.apache.commons.lang3.builder.ToStringBuilder.reflectionToString;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

/**
 * Domain GET response.
 *
 * @since 4.0
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "domainId"
})
public class DomainsGETResponse {

  /**
   * Domain identifier
   */
  @JsonProperty("domainId")
  @JsonPropertyDescription("")
  private String domainId;
  @JsonIgnore
  private Map<String, Object> additionalProperties = new HashMap<String, Object>();

  /**
   * No args constructor for use in serialization
   */
  public DomainsGETResponse() {}

  /**
   * Creates an instance of the response.
   *
   * @param domainId the identifier of the domain.
   */
  public DomainsGETResponse(String domainId) {
    super();
    this.domainId = domainId;
  }

  @JsonProperty("domainId")
  public String getDomainId() {
    return domainId;
  }

  @JsonProperty("domainId")
  public void setDomainId(String domainId) {
    this.domainId = domainId;
  }

  public DomainsGETResponse withDomainId(String domainId) {
    this.domainId = domainId;
    return this;
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  @JsonAnySetter
  public void setAdditionalProperty(String name, Object value) {
    this.additionalProperties.put(name, value);
  }

  public DomainsGETResponse withAdditionalProperty(String name, Object value) {
    this.additionalProperties.put(name, value);
    return this;
  }

  @Override
  public boolean equals(Object other) {
    if (other == this) {
      return true;
    }
    if ((other instanceof DomainsGETResponse) == false) {
      return false;
    }
    DomainsGETResponse rhs = ((DomainsGETResponse) other);
    return new EqualsBuilder().append(domainId, rhs.domainId).append(additionalProperties, rhs.additionalProperties)
        .isEquals();
  }

  @Override
  public int hashCode() {
    return new HashCodeBuilder().append(domainId).append(additionalProperties).toHashCode();
  }

  @Override
  public String toString() {
    return reflectionToString(this);
  }

}
