
/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.agent.rest.client.tooling.domains.domainId.components;

import org.mule.tooling.agent.rest.client.tooling.domains.domainId.components.componentId.ComponentId;

import javax.ws.rs.client.Client;

/**
 * Components web resource.
 *
 * @since 4.0
 */
public class Components {

  private String baseUrl;
  private Client client;

  public Components(String baseUrl, Client client) {
    this.baseUrl = (baseUrl + "/components");
    this.client = client;
  }

  private Client getClient() {
    return this.client;
  }

  private String getBaseUri() {
    return baseUrl;
  }

  /**
   * Access to the component resource.
   *
   * @param componentId the identifier of the component.
   * @return {@link ComponentId} to operate with.
   */
  public final ComponentId componentId(String componentId) {
    return new ComponentId(getBaseUri(), getClient(), componentId);
  }

}
