
/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.agent.rest.client.tooling.applications.model;

import static org.apache.commons.lang3.builder.ToStringBuilder.reflectionToString;

import java.util.HashMap;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

/**
 * Deploy application request
 *
 * @since 4.0
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "appLocation"
})
public class ApplicationsPUTBody {

  /**
   * id to be assigned to this deployment
   */
  @JsonProperty("id")
  @JsonPropertyDescription("")
  private String id;

  /**
   * Path to the application content
   */
  @JsonProperty("appLocation")
  @JsonPropertyDescription("")
  private String appLocation;
  /**
   * Reference to the domain
   */
  @JsonProperty("domainName")
  @JsonPropertyDescription("")
  private String domainName;
  @JsonProperty("content")
  @JsonPropertyDescription("")
  private byte[] content;
  @JsonProperty("deploymentProperties")
  @JsonPropertyDescription("")
  private Map<String, String> deploymentProperties;
  @JsonIgnore
  private Map<String, Object> additionalProperties = new HashMap<String, Object>();

  /**
   * No args constructor for use in serialization
   */
  public ApplicationsPUTBody() {}

  /**
   * Creates an intance of the request body.
   *
   * @param id          the identifier for this deployment
   * @param appLocation the location in file system for the application content to be deployed.
   * @param domainName  name for the domain to be linked to this application.
   */
  public ApplicationsPUTBody(String id, String appLocation, String domainName) {
    super();
    this.id = id;
    this.appLocation = appLocation;
    this.domainName = domainName;
  }

  @JsonProperty("id")
  public String getId() {
    return id;
  }

  @JsonProperty("id")
  public void setId(String id) {
    this.id = id;
  }

  public ApplicationsPUTBody withId(String id) {
    this.id = id;
    return this;
  }

  @JsonProperty("appLocation")
  public String getAppLocation() {
    return appLocation;
  }

  @JsonProperty("appLocation")
  public void setAppLocation(String appLocation) {
    this.appLocation = appLocation;
  }

  public ApplicationsPUTBody withAppLocation(String appLocation) {
    this.appLocation = appLocation;
    return this;
  }

  @JsonProperty("domainName")
  public String getDomainName() {
    return domainName;
  }

  @JsonProperty("domainName")
  public void setDomainName(String domainName) {
    this.domainName = domainName;
  }

  public ApplicationsPUTBody withDomainName(String domainName) {
    this.domainName = domainName;
    return this;
  }

  public byte[] getContent() {
    return content;
  }

  public void setContent(byte[] content) {
    this.content = content;
  }

  public ApplicationsPUTBody withContent(byte[] content) {
    this.content = content;
    return this;
  }

  public Map<String, String> getDeploymentProperties() {
    return deploymentProperties;
  }

  public void setDeploymentProperties(Map<String, String> deploymentProperties) {
    this.deploymentProperties = deploymentProperties;
  }

  public ApplicationsPUTBody withDeploymentProperties(Map<String, String> deploymentProperties) {
    this.deploymentProperties = deploymentProperties;
    return this;
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  @JsonAnySetter
  public void setAdditionalProperty(String name, Object value) {
    this.additionalProperties.put(name, value);
  }

  public ApplicationsPUTBody withAdditionalProperty(String name, Object value) {
    this.additionalProperties.put(name, value);
    return this;
  }

  @Override
  public boolean equals(Object other) {
    if (other == this) {
      return true;
    }
    if ((other instanceof ApplicationsPUTBody) == false) {
      return false;
    }
    ApplicationsPUTBody rhs = ((ApplicationsPUTBody) other);
    return new EqualsBuilder()
        .append(id, rhs.id)
        .append(appLocation, rhs.appLocation)
        .append(domainName, rhs.domainName)
        .append(content, rhs.content)
        .append(deploymentProperties, rhs.deploymentProperties)
        .append(additionalProperties, rhs.additionalProperties)
        .isEquals();
  }

  @Override
  public int hashCode() {
    return new HashCodeBuilder()
        .append(id)
        .append(appLocation)
        .append(domainName)
        .append(content)
        .append(deploymentProperties)
        .append(additionalProperties)
        .toHashCode();
  }

  @Override
  public String toString() {
    return reflectionToString(this);
  }

}
