/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.agent.rest.client.tooling.applications.applicationId.components.componentId.metadata;

import static javax.ws.rs.core.MediaType.APPLICATION_JSON_TYPE;
import static javax.ws.rs.core.Response.Status.Family.SUCCESSFUL;
import static org.glassfish.jersey.client.ClientProperties.READ_TIMEOUT;
import static org.mule.tooling.agent.rest.client.exceptions.ToolingAgentHandlerException.newToolingAgentHandlerException;
import static org.mule.tooling.agent.rest.client.tooling.Tooling.VERBOSE_QUERY_PARAM;

import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.extension.api.persistence.metadata.ComponentResultJsonSerializer;
import org.mule.tooling.agent.rest.client.exceptions.ToolingAgentHandlerException;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

/**
 * Metadata resource.
 *
 * @since 4.0
 */
public class Metadata {

  private static final String REDUCED_QUERY_PARAM = "reduced";
  private String baseUrl;
  private Client client;

  public Metadata(String baseUrl, Client client) {
    this.baseUrl = (baseUrl + "/metadata");
    this.client = client;
  }

  private Client getClient() {
    return this.client;
  }

  private String getBaseUri() {
    return baseUrl;
  }

  /**
   * GET operation, gets Metadata for the componentId of the application inside a flow.
   *
   * @param verboseErrorsEnabled flag that defines if it has to be verbose the response in case of errors/failures.
   * @param readTimeout          read timeout in milliseconds
   * @param reducedType          if will use the reduced metadata type serialization or the full one.
   *
   * @return {@link MetadataResult < ComponentMetadataDescriptor >} with the response.
   * @throws ToolingAgentHandlerException if there was an error.
   */
  public <T extends ComponentModel> MetadataResult<ComponentMetadataDescriptor<T>> get(boolean verboseErrorsEnabled,
                                                                                       int readTimeout,
                                                                                       boolean reducedType)
      throws ToolingAgentHandlerException {
    WebTarget target = this.getClient().target(getBaseUri());
    target = target.queryParam(VERBOSE_QUERY_PARAM, verboseErrorsEnabled);
    target = target.queryParam(REDUCED_QUERY_PARAM, reducedType);
    final javax.ws.rs.client.Invocation.Builder invocationBuilder = target.request(APPLICATION_JSON_TYPE);
    if (readTimeout > 0) {
      invocationBuilder.property(READ_TIMEOUT, readTimeout);
    }
    Response response = invocationBuilder.get();
    if (response.getStatusInfo().getFamily() != SUCCESSFUL) {
      throw newToolingAgentHandlerException(response);
    }
    // TODO MULE-10794 : Cannot reuse serializer between calls
    return new ComponentResultJsonSerializer<T>(false, reducedType).deserialize(response.readEntity(String.class));
  }
}
