/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.agent.rest.client.tooling.applications.applicationId.cache.config;

import static javax.ws.rs.core.MediaType.APPLICATION_JSON_TYPE;
import static javax.ws.rs.core.Response.Status.Family.SUCCESSFUL;
import static org.mule.tooling.agent.rest.client.exceptions.ToolingAgentHandlerException.newToolingAgentHandlerException;
import static org.mule.tooling.agent.rest.client.tooling.Tooling.VERBOSE_QUERY_PARAM;

import org.mule.tooling.agent.rest.client.exceptions.ToolingAgentHandlerException;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

/**
 * HashKey from cache (Metadata) web resource, represents a hash generated by Tooling Runtime Client to which a cache is defined
 * in Mule Runtime to store resources needed in order to resolve metadata.
 *
 * This hashKey is in {@link String} format and it is generated based on parameters, identifier and more data that comes from the
 * component models.
 *
 * @since 4.1.4
 */
public class HashKey {

  private String baseUrl;
  private Client client;

  public HashKey(String baseUrl, Client client, String config) {
    this.baseUrl = (baseUrl + ("/" + config));
    this.client = client;
  }

  private Client getClient() {
    return this.client;
  }

  private String getBaseUri() {
    return baseUrl;
  }

  /**
   * DELETE operation, disposes cache for given hashKey/hashKey from Metadata on the given artifact (which is shared across
   * deployments).
   *
   * @param verboseErrorsEnabled flag that defines if it has to be verbose the response in case of errors/failures.
   * @throws ToolingAgentHandlerException if there was an error.
   * @param verboseErrorsEnabled
   */
  public void delete(boolean verboseErrorsEnabled) throws ToolingAgentHandlerException {
    WebTarget target = this.getClient().target(getBaseUri());
    target = target.queryParam(VERBOSE_QUERY_PARAM, verboseErrorsEnabled);
    final javax.ws.rs.client.Invocation.Builder invocationBuilder = target.request(APPLICATION_JSON_TYPE);
    Response response = invocationBuilder.delete();
    if (response.getStatusInfo().getFamily() != SUCCESSFUL) {
      throw newToolingAgentHandlerException(response);
    }
  }

}
