/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.agent.rest.client.tooling.applications.applicationId.cache;

import org.mule.tooling.agent.rest.client.tooling.applications.applicationId.cache.config.HashKey;

import javax.ws.rs.client.Client;

/**
 * Cache (Metadata) web resource.
 *
 * @since 4.1.4
 */
public class Cache {

  private String baseUrl;
  private Client client;
  public HashKey hashKey;

  public Cache(String baseUrl, Client client) {
    this.baseUrl = (baseUrl + "/cache");
    this.client = client;
  }

  private Client getClient() {
    return this.client;
  }

  private String getBaseUri() {
    return baseUrl;
  }

  /**
   * Access to the cache for a given hashKey/hashKey resource.
   *
   * @param config the identifier of the cache entry.
   * @return {@link HashKey} to operate with.
   */
  public final HashKey hashKey(String config) {
    return new HashKey(getBaseUri(), getClient(), config);
  }

}
