/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.agent.rest.client.exceptions.model;

import static org.apache.commons.lang3.builder.ToStringBuilder.reflectionToString;
import static org.apache.commons.lang3.builder.ToStringStyle.JSON_STYLE;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "errorType",
    "errorMessage",
    "errorDetail"
})
public class ErrorEntity {

  @JsonProperty("errorType")
  @JsonPropertyDescription("")
  private String errorType;

  @JsonProperty("errorMessage")
  @JsonPropertyDescription("")
  private String errorMessage;

  @JsonProperty("errorDetail")
  @JsonPropertyDescription("")
  private String errorDetail;

  @JsonIgnore
  private Map<String, Object> additionalProperties = new HashMap<String, Object>();

  /**
   * No args constructor for use in serialization
   */
  public ErrorEntity() {}

  /**
   * Creates an instance of the entity.
   *
   * @param errorType    type of the error.
   * @param errorMessage message associated with it.
   * @param errorDetail  detail containing the stacktrace of the error.
   */
  public ErrorEntity(String errorType, String errorMessage, String errorDetail) {
    this.errorType = errorType;
    this.errorMessage = errorMessage;
    this.errorDetail = errorDetail;
  }

  @JsonProperty("errorType")
  public String getErrorType() {
    return errorType;
  }

  @JsonProperty("errorType")
  public void setErrorType(String errorType) {
    this.errorType = errorType;
  }

  public ErrorEntity withErrorType(String errorType) {
    this.errorType = errorType;
    return this;
  }

  @JsonProperty("errorMessage")
  public String getErrorMessage() {
    return errorMessage;
  }

  @JsonProperty("errorMessage")
  public void setErrorMessage(String errorMessage) {
    this.errorMessage = errorMessage;
  }

  public ErrorEntity withErrorMessage(String errorMessage) {
    this.errorMessage = errorMessage;
    return this;
  }

  @JsonProperty("errorDetail")
  public String getErrorDetail() {
    return errorDetail;
  }

  @JsonProperty("errorDetail")
  public void setErrorDetail(String errorDetail) {
    this.errorDetail = errorDetail;
  }

  public ErrorEntity withErrorDetail(String errorDetail) {
    this.errorDetail = errorDetail;
    return this;
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  @JsonAnySetter
  public void setAdditionalProperty(String name, Object value) {
    this.additionalProperties.put(name, value);
  }

  public ErrorEntity withAdditionalProperty(String name, Object value) {
    this.additionalProperties.put(name, value);
    return this;
  }

  @Override
  public boolean equals(Object other) {
    if (other == this) {
      return true;
    }
    if ((other instanceof ErrorEntity) == false) {
      return false;
    }
    ErrorEntity rhs = ((ErrorEntity) other);
    return new EqualsBuilder().append(errorType, rhs.errorType).append(errorMessage, rhs.errorMessage)
        .append(errorDetail, rhs.errorDetail).isEquals();
  }

  @Override
  public int hashCode() {
    return new HashCodeBuilder().append(errorType).append(errorMessage).append(errorDetail).toHashCode();
  }

  @Override
  public String toString() {
    return reflectionToString(this, JSON_STYLE);
  }

}
