/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.agent.rest.client;

import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public class VersionUtils {

  private VersionUtils() {}

  /**
   * Compares the provided runtime version with the provided one the check if it's greater.
   *
   * @param runtimeVersion       The version of the runtime to compare to.
   * @param minimumVersionString The minimum version to check.
   * @return {@code true} if the current version is equal or greater than the minimum version.
   */
  public static boolean isVersionGreaterOrEqualThan(String runtimeVersion, String minimumVersionString) {
    DefaultArtifactVersion minimumVersion = new DefaultArtifactVersion(minimumVersionString);
    DefaultArtifactVersion currentVersion = new DefaultArtifactVersion(runtimeVersion);
    boolean isCurrentVersionGreaterOrEqualThan = currentVersion.compareTo(minimumVersion) >= 0;

    return isCurrentVersionGreaterOrEqualThan;
  }

}
