/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.agent.rest.client.exceptions;

import java.util.Optional;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.mule.tooling.agent.rest.client.exceptions.model.ErrorEntity;

public class ToolingAgentHandlerException
extends RuntimeException {
    private ErrorEntity errorEntity;

    private ToolingAgentHandlerException(int statusCode, String reasonPhrase, String causeMessage) {
        super(ToolingAgentHandlerException.createMessage(statusCode, reasonPhrase, causeMessage));
    }

    private ToolingAgentHandlerException(int statusCode, String reasonPhrase, ErrorEntity errorEntity) {
        super(ToolingAgentHandlerException.createMessage(statusCode, reasonPhrase, errorEntity.toString()));
        this.errorEntity = errorEntity;
    }

    private static String createMessage(int statusCode, String reasonPhrase, String causeMessage) {
        return "Got status code: " + statusCode + " when trying to resolve a Mule Runtime operation. Reason: '" + reasonPhrase + (StringUtils.isNotBlank((CharSequence)causeMessage) ? ". " + causeMessage : "") + "'";
    }

    public Optional<ErrorEntity> getErrorEntity() {
        return Optional.ofNullable(this.errorEntity);
    }

    public static ToolingAgentHandlerException newToolingAgentHandlerException(Response response) {
        int statusCode = response.getStatusInfo().getStatusCode();
        String reasonPhrase = response.getStatusInfo().getReasonPhrase();
        if (response.hasEntity() && response.getMediaType().equals((Object)MediaType.APPLICATION_JSON_TYPE)) {
            ErrorEntity errorEntity = (ErrorEntity)response.readEntity(ErrorEntity.class);
            return new ToolingAgentHandlerException(statusCode, reasonPhrase, errorEntity);
        }
        return new ToolingAgentHandlerException(statusCode, reasonPhrase, (String)response.readEntity(String.class));
    }
}

