/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.agent.rest.client;

import java.io.File;
import java.io.InputStream;
import java.util.UUID;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;

@Feature("Remote Runtime Tooling Service - Domain deployment endpoints using deployment properties")
@Story("DeployToolingArtifact")
public class DeployDomainWithDeploymentPropertiesTestCase extends DeployDomainTestCase {

  @Override
  protected String doDeployDomain(File domainLocation) {
    String id = UUID.randomUUID().toString();
    return restAgentToolingService.deployDomain(null, domainLocation, getDeploymentProperties());
  }

  @Override
  protected String doDeployDomain(InputStream inputStream) {
    String id = UUID.randomUUID().toString();
    return restAgentToolingService.deployDomain(null, inputStream, getDeploymentProperties());
  }

}
