/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.agent.rest.client.exceptions;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.mule.tooling.agent.rest.client.exceptions.model.ErrorCode;
import org.mule.tooling.agent.rest.client.exceptions.model.ErrorEntity;

public class ToolingServiceAPIException
extends RuntimeException {
    private int statusCode;
    private String reasonPhrase;
    private ErrorEntity errorEntity;

    private ToolingServiceAPIException(int statusCode, String reasonPhrase, String causeMessage, Throwable cause) {
        super(ToolingServiceAPIException.createMessage(statusCode, reasonPhrase, causeMessage), cause);
        this.statusCode = statusCode;
        this.reasonPhrase = reasonPhrase;
    }

    private ToolingServiceAPIException(int statusCode, String reasonPhrase, ErrorEntity errorEntity, Throwable cause) {
        super(ToolingServiceAPIException.createMessage(statusCode, reasonPhrase, errorEntity.toString()), cause);
        this.statusCode = statusCode;
        this.reasonPhrase = reasonPhrase;
        this.errorEntity = errorEntity;
    }

    private static String createMessage(int statusCode, String reasonPhrase, String causeMessage) {
        return "HTTP " + statusCode + " " + reasonPhrase + (StringUtils.isNotBlank((CharSequence)causeMessage) ? ". " + causeMessage : "");
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public ErrorCode getErrorCode() {
        if (this.errorEntity == null) {
            return null;
        }
        return ErrorCode.get(this.errorEntity.getErrorType());
    }

    public static ToolingServiceAPIException newToolingServiceAPIException(Response response) {
        return ToolingServiceAPIException.newToolingServiceAPIException(response, null);
    }

    public static ToolingServiceAPIException newToolingServiceAPIException(Response response, Throwable cause) {
        int statusCode = response.getStatusInfo().getStatusCode();
        String reasonPhrase = response.getStatusInfo().getReasonPhrase();
        if (response.hasEntity() && response.getMediaType().equals((Object)MediaType.APPLICATION_JSON_TYPE)) {
            ErrorEntity errorEntity = (ErrorEntity)response.readEntity(ErrorEntity.class);
            return new ToolingServiceAPIException(statusCode, reasonPhrase, errorEntity, cause);
        }
        return new ToolingServiceAPIException(statusCode, reasonPhrase, (String)response.readEntity(String.class), cause);
    }
}

