/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.win32;

import com.install4j.api.Util;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.platform.win32.Common;

public class Win32Services {
    public static final int SERVICE_NO_CHANGE = -1;
    public static final int SERVICE_AUTO_START = 2;
    public static final int SERVICE_DEMAND_START = 3;
    public static final int SERVICE_DISABLED = 4;
    public static final int SERVICE_NON_INTERACTIVE_PROCESS = 16;
    public static final int SERVICE_INTERACTIVE_PROCESS = 272;
    public static final int ERROR_ACCESS_DENIED = 5;
    public static final int ERROR_SERVICE_ALREADY_RUNNING = 1056;
    public static final int ERROR_INVALID_SERVICE_ACCOUNT = 1057;
    public static final int ERROR_SERVICE_DOES_NOT_EXIST = 1060;
    public static final int ERROR_SERVICE_NOT_ACTIVE = 1062;
    public static final int ERROR_SERVICE_LOGON_FAILED = 1069;
    public static final int ERROR_SERVICE_MARKED_FOR_DELETE = 1072;
    public static final int ERROR_SERVICE_EXISTS = 1073;
    private static final int SERVICE_RUNNING = 4;

    private static native int installService0(String var0, String var1);

    private static native int changeServiceConfig0(String var0, String var1, int var2, int var3, String var4, String var5, String var6, String var7);

    private static native int setRestartServiceConfig0(String var0, boolean var1, int var2);

    private static native int stopService0(String var0);

    private static native int startService0(String var0);

    private static native int uninstallService0(String var0);

    private static native int queryStatus0(String var0);

    private static native int getStartType0(String var0);

    private static native String getServiceBinary0(String var0);

    public static boolean isRunning(String string) throws ServiceException {
        if (!Util.isWindows() || Util.isWindows9X()) {
            return false;
        }
        if (string == null) {
            throw new IllegalArgumentException("serviceName required");
        }
        int n = Win32Services.queryStatus0(string);
        if (n <= 0) {
            return -n == 4;
        }
        throw new ServiceException(n);
    }

    public static int getStartType(String string) throws ServiceException {
        if (!Util.isWindows() || Util.isWindows9X()) {
            return 4;
        }
        if (string == null) {
            throw new IllegalArgumentException("serviceName required");
        }
        int n = Win32Services.getStartType0(string);
        if (n <= 0) {
            return -n;
        }
        throw new ServiceException(n);
    }

    public static String getServiceBinary(String string) throws ServiceException {
        if (!Util.isWindows() || Util.isWindows9X()) {
            return null;
        }
        if (string == null) {
            throw new IllegalArgumentException("serviceName required");
        }
        String string2 = Win32Services.getServiceBinary0(string);
        if (string2.startsWith(" ")) {
            throw new ServiceException(Integer.parseInt(string2.substring(1)));
        }
        return string2;
    }

    public static void installService(String string, String string2) throws ServiceException {
        if (!Util.isWindows() || Util.isWindows9X()) {
            return;
        }
        if (string == null) {
            throw new IllegalArgumentException("serviceName required");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("pathName required");
        }
        int n = Win32Services.installService0(string, string2);
        if (n != 0) {
            throw new ServiceException(n);
        }
    }

    public static void changeServiceConfig(String string, String string2, boolean bl, int n, String string3, String string4, String string5, String string6) throws ServiceException {
        int n2;
        if (!Util.isWindows() || Util.isWindows9X()) {
            return;
        }
        if (string == null) {
            throw new IllegalArgumentException("serviceName required");
        }
        if (!Util.isAtLeastWindowsXP()) {
            string4 = null;
            string5 = null;
        }
        if ((n2 = Win32Services.changeServiceConfig0(string, string2, bl ? 272 : 16, n, string3, string4, string5, string6)) != 0) {
            throw new ServiceException(n2);
        }
    }

    public static void setRestartServiceConfig(String string, boolean bl, int n) throws ServiceException {
        if (!InstallerUtil.isAtLeastWindows2000()) {
            return;
        }
        if (string == null) {
            throw new IllegalArgumentException("serviceName required");
        }
        int n2 = Win32Services.setRestartServiceConfig0(string, bl, n);
        if (n2 != 0) {
            throw new ServiceException(n2);
        }
    }

    public static void stopService(String string) throws ServiceException {
        if (!Util.isWindows() || Util.isWindows9X()) {
            return;
        }
        if (string == null) {
            throw new IllegalArgumentException("serviceName required");
        }
        int n = Win32Services.stopService0(string);
        if (n != 0) {
            throw new ServiceException(n);
        }
    }

    public static void startService(String string) throws ServiceException {
        if (!Util.isWindows() || Util.isWindows9X()) {
            return;
        }
        if (string == null) {
            throw new IllegalArgumentException("serviceName required");
        }
        int n = Win32Services.startService0(string);
        if (n != 0) {
            throw new ServiceException(n);
        }
    }

    public static void uninstallService(String string) throws ServiceException {
        if (!Util.isWindows() || Util.isWindows9X()) {
            return;
        }
        if (string == null) {
            throw new IllegalArgumentException("serviceName required");
        }
        int n = Win32Services.uninstallService0(string);
        if (n != 0 && n != 1072) {
            throw new ServiceException(n);
        }
    }

    public static void main(String[] stringArray) throws InterruptedException, ServiceException {
        System.out.println(Win32Services.isRunning("exe4j Service Demo"));
        System.out.println(Win32Services.getStartType("exe4j Service Demo"));
        System.out.println(Win32Services.getServiceBinary("exe4j Service Demo"));
        Win32Services.startService("exe4j Service Demo");
        System.out.println(Win32Services.isRunning("exe4j Service Demo"));
        Thread.sleep(5000L);
        System.out.println(Win32Services.isRunning("exe4j Service Demo"));
        System.out.println("s");
        Win32Services.stopService("exe4j Service Demo");
        System.out.println(Win32Services.isRunning("exe4j Service Demo"));
    }

    static {
        Common.init();
    }

    public static class ServiceException
    extends Exception {
        private int errorCode;

        public ServiceException(int n) {
            this.errorCode = n;
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        public String toString() {
            return "ServiceException{errorCode=" + this.errorCode + '}';
        }
    }
}

