/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.apiimpl;

import com.exe4j.runtime.util.ResourceHelper;
import com.install4j.api.Util;
import com.install4j.api.launcher.ApplicationLauncher;
import com.install4j.api.launcher.Variables;
import com.install4j.runtime.beans.applications.ApplicationWithPath;
import com.install4j.runtime.beans.applications.CustomApplication;
import com.install4j.runtime.installer.Application;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.content.ContentInstaller;
import com.install4j.runtime.installer.helper.launching.LaunchDescriptor;
import com.install4j.runtime.installer.helper.launching.LaunchHelper;
import com.install4j.runtime.util.StringUtil;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.SwingUtilities;

public class ApplicationLauncherImpl {
    public static void launchApplicationInProcess(final String string, final String[] stringArray, final ApplicationLauncher.Callback callback, final ApplicationLauncher.WindowMode windowMode, final Window window) {
        if (InstallerConfig.getCurrentApplication() != null) {
            throw new IllegalStateException("Only one installer application can be run at the same time.");
        }
        Runnable runnable = new Runnable(){

            public void run() {
                InstallerUtil.setInProcessCallback(callback);
                Application.runApplicationInProcess(string, stringArray, windowMode == ApplicationLauncher.WindowMode.DIALOG, window);
                Variables.clearInstallerVariablesCache();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            new Thread(runnable).start();
        } else {
            runnable.run();
        }
    }

    public static void launchApplication(String string, String[] stringArray, boolean bl, ApplicationLauncher.Callback callback) throws IOException {
        Object object;
        Object object2;
        InstallerConfig installerConfig = InstallerConfig.getConfigFromFile(InstallerUtil.getInstallerFile("i4jparams.conf"));
        if (installerConfig == null) {
            throw new IOException("Could not read config");
        }
        com.install4j.runtime.beans.applications.Application application = installerConfig.getApplicationById(string);
        if (application == null) {
            throw new IOException("Application with ID " + string + " could not be found");
        }
        if (!(application instanceof CustomApplication)) {
            throw new IOException("Application is no custom application");
        }
        CustomApplication customApplication = (CustomApplication)application;
        File file = ApplicationLauncherImpl.getExeFile(customApplication);
        File file2 = File.createTempFile("i4jshd", ".tmp");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (!file.exists()) {
            StringUtil.splitupCommandLine(arrayList, customApplication.getVmParameters());
            if (Util.isMacOS()) {
                StringUtil.splitupCommandLine(arrayList, ApplicationLauncherImpl.getDockOptions(installerConfig, customApplication, string, file));
            }
            arrayList.add("-classpath");
            object2 = new File(ResourceHelper.getRuntimeDir(), "i4jruntime.jar").getAbsolutePath() + File.pathSeparator + new File(ResourceHelper.getRuntimeDir(), "user.jar").getAbsolutePath();
            object = new File(ResourceHelper.getRuntimeDir(), "user").listFiles();
            if (object != null) {
                for (int i = 0; i < ((Object)object).length; ++i) {
                    Object object3 = object[i];
                    if (!((File)object3).getName().endsWith(".jar") && !((File)object3).getName().endsWith(".zip")) continue;
                    object2 = (String)object2 + File.pathSeparator + ((File)object3).getAbsolutePath();
                }
            }
            arrayList.add(object2);
            arrayList.add(Application.class.getName());
            arrayList.add(String.valueOf(string));
            StringUtil.splitupCommandLine(arrayList, customApplication.getArguments());
            file = new File(System.getProperty("java.home"), "bin/java");
        }
        if (stringArray != null) {
            arrayList.addAll(Arrays.asList(stringArray));
        }
        arrayList.add("-Dinstall4j.shutdownFile=" + file2.getAbsolutePath());
        object2 = new LaunchDescriptor(file).arguments(arrayList.toArray(new String[arrayList.size()])).receiveProcess(true);
        if (LaunchHelper.launchApplication((LaunchDescriptor)object2) == null) {
            throw new IOException("Could not start process");
        }
        object = new CommFileWaiter(file2, callback, ((LaunchDescriptor)object2).getProcess());
        ((Thread)object).start();
        if (bl) {
            try {
                ((LaunchDescriptor)object2).getProcess().waitFor();
                ((Thread)object).join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public static File getExeFile(ApplicationWithPath applicationWithPath) {
        File file = applicationWithPath.getExecutableDirectory();
        file = file == null || file.getPath().trim().equals("") ? ResourceHelper.getRuntimeDir() : new File(ResourceHelper.getRuntimeDir(), "../" + file.getPath());
        File file2 = null;
        try {
            file2 = new File(file, applicationWithPath.getExecutableName() + (Util.isWindows() ? ".exe" : ""));
            file2 = file2.getCanonicalFile();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return file2;
    }

    public static String getDockOptions(InstallerConfig installerConfig, ApplicationWithPath applicationWithPath, String string, File file) {
        String string2;
        String string3 = "";
        File file2 = new File(file.getAbsolutePath() + ".app", "Contents/Resources/app.icns");
        if (!file2.exists() && string.equals("uninstaller")) {
            string2 = ContentInstaller.replaceSlashes(installerConfig.getApplicationName());
            String string4 = MessageFormat.format(Messages.getMessages().getString("UninstallerMenuEntry"), string2);
            file2 = new File(file.getParentFile() + "/" + string4 + ".app", "Contents/Resources/app.icns");
        }
        if (!file2.exists() && installerConfig.getMacSpecificConfig().isSingleBundle()) {
            string2 = applicationWithPath.getUsedExecutableDirectory();
            if (string2.startsWith(installerConfig.getMacSpecificConfig().getRuntimeDirParent())) {
                string2 = string2.substring(installerConfig.getMacSpecificConfig().getRuntimeDirParent().length());
            }
            if (!(file2 = new File(ResourceHelper.getRuntimeDir(), "icons/" + string2 + "/" + applicationWithPath.getExecutableName() + ".icns")).exists()) {
                file2 = new File(ResourceHelper.getRuntimeDir(), "icons/app.icns");
            }
        }
        if (file2.exists()) {
            string3 = string3 + "\"-Xdock:icon=" + file2.getAbsolutePath() + "\" ";
        }
        string3 = string3 + "\"-Xdock:name=" + applicationWithPath.getExecutableName() + "\"";
        return string3;
    }

    private static class CommFileWaiter
    extends Thread {
        private File commFile;
        private ApplicationLauncher.Callback callback;
        private Process process;

        private CommFileWaiter(File file, ApplicationLauncher.Callback callback, Process process) {
            super("_i4j_commfile_waiter");
            this.setDaemon(true);
            this.setPriority(4);
            this.process = process;
            this.commFile = file;
            this.callback = callback;
            file.deleteOnExit();
        }

        public void run() {
            boolean bl = true;
            int n = 0;
            while (bl && this.commFile.length() == 0L) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                try {
                    n = this.process.exitValue();
                    bl = false;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {}
            }
            this.exited(n);
        }

        public synchronized void exited(int n) {
            Variables.clearInstallerVariablesCache();
            if (this.commFile.length() > 0L) {
                if (this.callback != null) {
                    this.callback.prepareShutdown();
                }
                System.exit(0);
            } else if (this.callback != null) {
                this.callback.exited(n);
            }
            this.commFile.delete();
        }
    }
}

