/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.install4j.runtime.beans.actions.xml.NodeListProvider;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelper;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlHelper {
    private static Transformer stringTransformer;

    private XmlHelper() {
    }

    public static Document createDocument() throws IOException {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw XmlHelper.createIoException(parserConfigurationException);
        }
    }

    public static Document parseFile(File file) throws IOException {
        return XmlHelper.parseFile(file, false, false);
    }

    public static Document parseFile(File file, boolean bl, boolean bl2) throws IOException {
        return XmlHelper.parse(new InputSource(file.toURI().toASCIIString()), bl, bl2);
    }

    private static Document parse(InputSource inputSource, boolean bl, boolean bl2) throws IOException {
        DocumentBuilder documentBuilder;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(bl);
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw XmlHelper.createIoException(parserConfigurationException);
        }
        if (bl) {
            documentBuilder.setErrorHandler(new ErrorHandler(){

                public void error(SAXParseException sAXParseException) throws SAXException {
                    XmlHelper.log(sAXParseException);
                }

                public void fatalError(SAXParseException sAXParseException) throws SAXException {
                    XmlHelper.log(sAXParseException);
                }

                public void warning(SAXParseException sAXParseException) throws SAXException {
                }
            });
        }
        if (!bl2) {
            documentBuilder.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
                    if (string2.startsWith("http:/")) {
                        return new InputSource(new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>"));
                    }
                    return null;
                }
            });
        }
        try {
            return documentBuilder.parse(inputSource);
        }
        catch (SAXException sAXException) {
            throw XmlHelper.createIoException(sAXException);
        }
    }

    public static Document parseString(String string, boolean bl, boolean bl2) throws IOException {
        return XmlHelper.parse(new InputSource(new StringReader(string)), bl, bl2);
    }

    public static void writeFile(File file, Document document) throws IOException {
        try {
            XmlHelper.writeFile(file, document, VersionSpecificHelper.createTransformerFactory().newTransformer());
        }
        catch (TransformerException transformerException) {
            throw XmlHelper.createIoException(transformerException);
        }
    }

    public static void writeFile(File file, Document document, Transformer transformer) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        XmlHelper.writeToStream(document, transformer, fileOutputStream);
    }

    public static byte[] getBytes(Document document) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XmlHelper.writeToStream(document, VersionSpecificHelper.createTransformerFactory().newTransformer(), byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (TransformerException transformerException) {
            throw XmlHelper.createIoException(transformerException);
        }
    }

    private static void writeToStream(Document document, Transformer transformer, OutputStream outputStream) throws IOException {
        transformer.setErrorListener(new ErrorListener(){

            public void error(TransformerException transformerException) throws TransformerException {
                XmlHelper.log(transformerException);
            }

            public void fatalError(TransformerException transformerException) throws TransformerException {
                XmlHelper.log(transformerException);
            }

            public void warning(TransformerException transformerException) throws TransformerException {
            }
        });
        transformer.setOutputProperty("indent", "yes");
        DocumentType documentType = document.getDoctype();
        if (documentType != null && documentType.getSystemId() != null) {
            transformer.setOutputProperty("doctype-system", documentType.getSystemId());
            String string = documentType.getPublicId();
            if (string != null && string.trim().length() > 0) {
                transformer.setOutputProperty("doctype-public", string);
            }
        }
        try {
            transformer.transform(new DOMSource(document), new StreamResult(outputStream));
        }
        catch (TransformerException transformerException) {
            throw XmlHelper.createIoException(transformerException);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String getString(Element element) throws IOException {
        StringWriter stringWriter = new StringWriter();
        try {
            if (stringTransformer == null) {
                stringTransformer = VersionSpecificHelper.createTransformerFactory().newTransformer();
                stringTransformer.setOutputProperty("indent", "no");
                stringTransformer.setOutputProperty("omit-xml-declaration", "yes");
                stringTransformer.setOutputProperty("encoding", "UTF-8");
            }
            stringTransformer.transform(new DOMSource(element), new StreamResult(stringWriter));
            return stringWriter.toString();
        }
        catch (TransformerException transformerException) {
            throw XmlHelper.createIoException(transformerException);
        }
    }

    public static Element findChild(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        if (n == 0) {
            return null;
        }
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element element2 = (Element)node;
            if (string != null && !element2.getTagName().equals(string)) continue;
            return element2;
        }
        return null;
    }

    public static Iterator childElements(Element element) {
        if (element == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        ArrayList<Node> arrayList = new ArrayList<Node>(n);
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            arrayList.add(node);
        }
        return arrayList.iterator();
    }

    public static String readAttribute(Element element, String string, String string2) {
        if (!element.hasAttribute(string)) {
            string = string.toUpperCase();
        }
        if (element.hasAttribute(string)) {
            return element.getAttribute(string);
        }
        return string2;
    }

    public static String readFileAttribute(Element element, String string, String string2) {
        if (!element.hasAttribute(string)) {
            string = string.toUpperCase();
        }
        if (element.hasAttribute(string)) {
            return element.getAttribute(string).replace('\\', File.separatorChar).replace('/', File.separatorChar);
        }
        return string2;
    }

    public static boolean readAttribute(Element element, String string, boolean bl) {
        if (!element.hasAttribute(string)) {
            string = string.toUpperCase();
        }
        if (element.hasAttribute(string)) {
            return Boolean.valueOf(element.getAttribute(string));
        }
        return bl;
    }

    public static int readAttribute(Element element, String string, int n) {
        if (!element.hasAttribute(string)) {
            string = string.toUpperCase();
        }
        if (element.hasAttribute(string)) {
            return Integer.parseInt(element.getAttribute(string));
        }
        return n;
    }

    public static long readAttribute(Element element, String string, long l) {
        if (!element.hasAttribute(string)) {
            string = string.toUpperCase();
        }
        if (element.hasAttribute(string)) {
            return Long.parseLong(element.getAttribute(string));
        }
        return l;
    }

    public static Color readAttribute(Element element, String string, Color color) {
        if (!element.hasAttribute(string)) {
            string = string.toUpperCase();
        }
        if (element.hasAttribute(string)) {
            String string2 = element.getAttribute(string);
            if (string2.length() > 0) {
                return new Color(Integer.parseInt(string2));
            }
            return null;
        }
        return color;
    }

    public static String getTextValue(Element element) {
        if (element == null) {
            return "";
        }
        Node node = element.getFirstChild();
        return node == null ? "" : node.getNodeValue();
    }

    private static IOException createIoException(Exception exception) {
        IOException iOException = new IOException();
        iOException.initCause(exception);
        return iOException;
    }

    private static void log(Exception exception) {
        Logger.getInstance().error(null, exception.getMessage());
    }

    public static NodeList getNodeList(Document document, String string) {
        NodeListProvider nodeListProvider = VersionSpecificHelper.createNodeListProvider();
        if (nodeListProvider == null) {
            return null;
        }
        return nodeListProvider.getNodeList(document, string);
    }
}

