/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.util.ButtonUtil;
import com.install4j.runtime.util.DisplayTextArea;
import com.install4j.runtime.util.StandardDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;

public class RunningProcessesDialog
extends StandardDialog {
    private String message;
    private Collection processes;
    private List buttonTexts;
    private List buttons;
    private JList lstProcesses;
    private JScrollPane scpProcesses;
    private int selectedButtonIndex;

    public static RunningProcessesDialog create(Window window, String string, Collection collection, List list) {
        if (window instanceof Frame) {
            return new RunningProcessesDialog((Frame)window, string, collection, list);
        }
        return new RunningProcessesDialog((Dialog)window, string, collection, list);
    }

    private RunningProcessesDialog(Frame frame, String string, Collection collection, List list) {
        super(frame);
        this.init(string, collection, list);
    }

    private RunningProcessesDialog(Dialog dialog, String string, Collection collection, List list) {
        super(dialog);
        this.init(string, collection, list);
    }

    private void init(String string, Collection collection, List list) {
        this.message = string;
        this.processes = collection;
        this.buttonTexts = list;
        this.init();
    }

    public int getSelectedButtonIndex() {
        return this.selectedButtonIndex;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        int n = this.buttons.indexOf(object);
        if (n >= 0) {
            this.selectedButtonIndex = n;
            this.doOk();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    protected void addScreenContent(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 15, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.right = 15;
        jPanel.add((Component)new JLabel(UIManager.getIcon("OptionPane.warningIcon")), gridBagConstraints);
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DisplayTextArea displayTextArea = new DisplayTextArea();
        displayTextArea.setText(this.message);
        jPanel.add((Component)displayTextArea, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets.bottom = 0;
        jPanel.add((Component)this.scpProcesses, gridBagConstraints);
        ++gridBagConstraints.gridy;
    }

    protected boolean isFillVertical() {
        return true;
    }

    protected JComponent createButtonBox() {
        ArrayList<JButton> arrayList = new ArrayList<JButton>(this.buttons);
        arrayList.add(this.getCancelButton());
        Box box = ButtonUtil.createHorizontalButtonBox(arrayList.toArray(new Component[arrayList.size()]), 0);
        Box box2 = Box.createHorizontalBox();
        box2.add(Box.createHorizontalGlue());
        box2.add(box);
        return box2;
    }

    protected void doCancel() {
        if (GUIHelper.confirmCancel(this)) {
            super.doCancel();
        }
    }

    protected void setupControls() {
        super.setupControls();
        this.lstProcesses = new JList<Object>(this.processes.toArray());
        this.scpProcesses = new JScrollPane(this.lstProcesses);
        this.buttons = new ArrayList(this.buttonTexts.size());
        Iterator iterator = this.buttonTexts.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            JButton jButton = new JButton(string);
            jButton.addActionListener(this);
            this.buttons.add(jButton);
        }
    }

    protected void setupComponent() {
        super.setupComponent();
        this.setTitle(Messages.getMessages().getString("RunningProcessesDetected"));
    }

    protected int getFrameHeight() {
        return 270;
    }

    protected int getFrameWidth() {
        return 400;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!bl) {
            this.dispose();
        }
    }
}

