/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.headless;

import com.install4j.api.Util;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.context.WizardContext;
import com.install4j.api.screens.Screen;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.DummyWizardContext;
import com.install4j.runtime.installer.config.ScreenBeanConfig;
import com.install4j.runtime.installer.controller.ActionCallback;
import com.install4j.runtime.installer.controller.CommandSink;
import com.install4j.runtime.installer.controller.ControllerCommand;
import com.install4j.runtime.installer.controller.GoForwardCommand;
import com.install4j.runtime.installer.controller.ScreenExecutor;
import com.install4j.runtime.installer.frontend.FormPanel;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.ConsoleImpl;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import java.io.FileDescriptor;
import java.net.InetAddress;
import java.security.Permission;
import java.util.Collections;
import javax.swing.JEditorPane;

public abstract class AbstractHeadlessScreenExecutor
implements ScreenExecutor {
    private CommandSink commandSink;
    private ContextImpl contextImpl;
    private boolean exitCalled = false;
    private WizardContext dummyWizardContext = this.createWizardContext();
    private boolean fileInstallerProgressInterfaceSet;

    public AbstractHeadlessScreenExecutor() {
        this.contextImpl = this.createContext();
    }

    protected abstract ContextImpl createContext();

    protected abstract boolean handleScreen(ScreenBeanConfig var1) throws UserCanceledException;

    protected DummyWizardContext createWizardContext() {
        return new DummyWizardContext();
    }

    protected void init(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = Util.isMacOS() && InstallerUtil.isAtLeastJava17();
        if (bl && !bl2) {
            System.setProperty("java.awt.headless", "true");
        }
        System.setSecurityManager(new CheckExitSecurityManager());
        Runtime.getRuntime().addShutdownHook(new Thread("shutdown hook"){

            public void run() {
                if (!AbstractHeadlessScreenExecutor.this.exitCalled && AbstractHeadlessScreenExecutor.this.commandSink != null) {
                    ConsoleImpl.getInstance().cancel();
                    ContextImpl.setCancelling();
                    AbstractHeadlessScreenExecutor.this.commandSink.returnToController(ControllerCommand.CANCEL);
                    AbstractHeadlessScreenExecutor.this.commandSink.waitForFinish();
                }
            }
        });
        if (!bl2 || !HelperCommunication.getInstance().isElevatedHelper()) {
            new FormPanel(Collections.EMPTY_LIST, this.getContext(), false, null);
            new JEditorPane("text/plain", "init text");
        }
    }

    public void execute(ScreenBeanConfig screenBeanConfig, CommandSink commandSink, boolean bl, ControllerCommand controllerCommand) {
        this.commandSink = commandSink;
        if (!this.fileInstallerProgressInterfaceSet) {
            FileInstaller.getInstance().setDefaultProgressInterface(this.getProgressInterface());
            this.fileInstallerProgressInterfaceSet = true;
        }
        try {
            if (this.handleScreen(screenBeanConfig)) {
                commandSink.returnToController(new GoForwardCommand(1, true, true, null));
            } else {
                commandSink.returnToController(ControllerCommand.CANCEL);
            }
        }
        catch (UserCanceledException userCanceledException) {
            commandSink.returnToController(ControllerCommand.CANCEL);
        }
        catch (Throwable throwable) {
            this.getContext().handleCriticalException(throwable);
        }
    }

    public CommandSink getCommandSink() {
        return this.commandSink;
    }

    public ProgressInterface getDefaultProgressInterface() {
        return this.getProgressInterface();
    }

    public WizardContext getWizardContext() {
        return this.dummyWizardContext;
    }

    public void setRollback() {
        this.getProgressInterface().setStatusMessage(Messages.getMessages().getString("StatusRollback"));
    }

    public void closeWindows() {
    }

    public ActionCallback getActionCallback() {
        return null;
    }

    public void register(Screen screen, ScreenBeanConfig screenBeanConfig) {
        this.getContext().applyToScreen(screen, screenBeanConfig);
    }

    public ContextImpl getContext() {
        return this.contextImpl;
    }

    public void initializeLazilyLoadedScreens() {
    }

    private class CheckExitSecurityManager
    extends SecurityManager {
        private CheckExitSecurityManager() {
        }

        public void checkPermission(Permission permission) {
        }

        public void checkPermission(Permission permission, Object object) {
        }

        public void checkCreateClassLoader() {
        }

        public void checkAccess(Thread thread) {
        }

        public void checkAccess(ThreadGroup threadGroup) {
        }

        public void checkExit(int n) {
            AbstractHeadlessScreenExecutor.this.exitCalled = true;
        }

        public void checkExec(String string) {
        }

        public void checkLink(String string) {
        }

        public void checkRead(FileDescriptor fileDescriptor) {
        }

        public void checkRead(String string) {
        }

        public void checkRead(String string, Object object) {
        }

        public void checkWrite(FileDescriptor fileDescriptor) {
        }

        public void checkWrite(String string) {
        }

        public void checkDelete(String string) {
        }

        public void checkConnect(String string, int n) {
        }

        public void checkConnect(String string, int n, Object object) {
        }

        public void checkListen(int n) {
        }

        public void checkAccept(String string, int n) {
        }

        public void checkMulticast(InetAddress inetAddress) {
        }

        public void checkMulticast(InetAddress inetAddress, byte by) {
        }

        public void checkPropertiesAccess() {
        }

        public void checkPropertyAccess(String string) {
        }

        public boolean checkTopLevelWindow(Object object) {
            return true;
        }

        public void checkPrintJobAccess() {
        }

        public void checkSystemClipboardAccess() {
        }

        public void checkAwtEventQueueAccess() {
        }

        public void checkPackageAccess(String string) {
        }

        public void checkPackageDefinition(String string) {
        }

        public void checkSetFactory() {
        }

        public void checkMemberAccess(Class clazz, int n) {
        }

        public void checkSecurityAccess(String string) {
        }
    }
}

