/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.controller;

import com.install4j.api.screens.Screen;
import com.install4j.runtime.beans.screens.FormScreen;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.config.AbstractBeanConfig;
import com.install4j.runtime.installer.config.GroupBeanConfig;
import com.install4j.runtime.installer.config.ScreenBeanConfig;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ScreenNavigator {
    private LinkedList screenConfigHistory = new LinkedList();
    private LinkedList groupStack = new LinkedList();
    private ContextImpl context;

    public ScreenNavigator(ContextImpl contextImpl) {
        this.context = contextImpl;
        this.groupStack.add(new GroupStackEntry(null, contextImpl.getScreenConfigs(), -1));
    }

    public void sync(ScreenBeanConfig screenBeanConfig) {
        this.groupStack.clear();
        this.fillGroupStack(null, this.context.getScreenConfigs(), screenBeanConfig);
    }

    private boolean fillGroupStack(GroupBeanConfig groupBeanConfig, List list, ScreenBeanConfig screenBeanConfig) {
        for (int i = 0; i < list.size(); ++i) {
            AbstractBeanConfig abstractBeanConfig;
            AbstractBeanConfig abstractBeanConfig2 = (AbstractBeanConfig)list.get(i);
            if (abstractBeanConfig2 instanceof ScreenBeanConfig) {
                abstractBeanConfig = (ScreenBeanConfig)abstractBeanConfig2;
                if (abstractBeanConfig != screenBeanConfig) continue;
                this.groupStack.add(new GroupStackEntry(groupBeanConfig, list, i));
                return true;
            }
            abstractBeanConfig = (GroupBeanConfig)abstractBeanConfig2;
            if (!this.fillGroupStack((GroupBeanConfig)abstractBeanConfig, ((GroupBeanConfig)abstractBeanConfig).getBeanConfigs(), screenBeanConfig)) continue;
            this.groupStack.addFirst(new GroupStackEntry(groupBeanConfig, list, i));
            return true;
        }
        return false;
    }

    public ScreenBeanConfig findNextScreenConfig(ScreenBeanConfig screenBeanConfig, int n, boolean bl) {
        if (this.getCurrentConfig() != screenBeanConfig) {
            this.sync(screenBeanConfig);
        }
        boolean bl2 = n == 1;
        for (int i = 0; i < n; ++i) {
            if (this.forward(bl2, bl)) continue;
            return null;
        }
        return (ScreenBeanConfig)this.getCurrentConfig();
    }

    public ScreenBeanConfig findPreviousScreenConfig(ScreenBeanConfig screenBeanConfig, int n) {
        if (this.getCurrentConfig() != screenBeanConfig) {
            this.sync(screenBeanConfig);
        }
        for (int i = 0; i < n; ++i) {
            if (this.backward()) continue;
            return null;
        }
        return (ScreenBeanConfig)this.getCurrentConfig();
    }

    private AbstractBeanConfig getCurrentConfig() {
        GroupStackEntry groupStackEntry = this.getCurrentStackEntry();
        if (groupStackEntry == null) {
            return null;
        }
        return groupStackEntry.getCurrentConfig();
    }

    public ScreenBeanConfig findPreviousScreenConfigInHistory(boolean bl, List list, int n) {
        ScreenBeanConfig screenBeanConfig = null;
        for (int i = 0; i < n && (screenBeanConfig = this.backwardInHistory(bl, list)) != null; ++i) {
        }
        return screenBeanConfig;
    }

    private ScreenBeanConfig backwardInHistory(boolean bl, List list) {
        ScreenBeanConfig screenBeanConfig = null;
        int n = this.screenConfigHistory.size() - 1;
        if (!bl) {
            --n;
        }
        HistoryEntry historyEntry = null;
        while (n >= 0) {
            Screen screen;
            historyEntry = (HistoryEntry)this.screenConfigHistory.get(n);
            screenBeanConfig = historyEntry.screenConfig;
            if (bl) {
                this.screenConfigHistory.remove(n);
            }
            if (!(screen = screenBeanConfig.getOrInstantiateScreen(false)).isHiddenForPrevious()) break;
            if (list != null) {
                list.addAll(screenBeanConfig.getActionConfigs());
            }
            --n;
        }
        if (bl && historyEntry != null) {
            this.groupStack = historyEntry.groupStack;
        }
        return screenBeanConfig;
    }

    private boolean forward(boolean bl, boolean bl2) {
        AbstractBeanConfig abstractBeanConfig;
        GroupStackEntry groupStackEntry = this.getCurrentStackEntry();
        while (groupStackEntry.index < groupStackEntry.screenConfigs.size() - 1) {
            AbstractBeanConfig abstractBeanConfig2;
            groupStackEntry.index++;
            abstractBeanConfig = (AbstractBeanConfig)groupStackEntry.screenConfigs.get(groupStackEntry.index);
            if (abstractBeanConfig instanceof GroupBeanConfig) {
                abstractBeanConfig2 = (GroupBeanConfig)abstractBeanConfig;
                if (bl2 && !this.context.checkGroupCondition((GroupBeanConfig)abstractBeanConfig2)) continue;
                this.context.initLoopIndex((GroupBeanConfig)abstractBeanConfig2, groupStackEntry.groupState);
                return this.enterGroup((GroupBeanConfig)abstractBeanConfig2, bl, bl2);
            }
            if (!(abstractBeanConfig instanceof ScreenBeanConfig)) continue;
            abstractBeanConfig2 = (ScreenBeanConfig)abstractBeanConfig;
            Screen screen = ((ScreenBeanConfig)abstractBeanConfig2).getOrInstantiateScreen(false);
            if (bl2 && (screen.isHidden() || screen.isHiddenForNext() || !this.context.runBooleanScript(abstractBeanConfig2.getConditionClassName(), screen))) continue;
            return true;
        }
        if (this.groupStack.size() > 1) {
            this.groupStack.removeLast();
            if (bl && this.context.isGroupLoop((GroupBeanConfig)(abstractBeanConfig = (GroupBeanConfig)this.getCurrentConfig()), this.getCurrentStackEntry().groupState)) {
                this.removeLastHistoryItem();
                this.resetInitializationOfContainedFormScreens((GroupBeanConfig)abstractBeanConfig);
                return this.enterGroup((GroupBeanConfig)abstractBeanConfig, true, bl2);
            }
            if (this.forward(bl, bl2)) {
                return true;
            }
        }
        return false;
    }

    private boolean backward() {
        GroupStackEntry groupStackEntry = this.getCurrentStackEntry();
        while (groupStackEntry.index > 0) {
            groupStackEntry.index--;
            AbstractBeanConfig abstractBeanConfig = (AbstractBeanConfig)groupStackEntry.screenConfigs.get(groupStackEntry.index);
            if (abstractBeanConfig instanceof GroupBeanConfig) {
                GroupBeanConfig groupBeanConfig = (GroupBeanConfig)abstractBeanConfig;
                this.groupStack.add(new GroupStackEntry(groupBeanConfig, groupBeanConfig.getBeanConfigs(), groupBeanConfig.getBeanConfigs().size()));
                if (this.backward()) {
                    return true;
                }
                this.groupStack.removeLast();
                continue;
            }
            if (!(abstractBeanConfig instanceof ScreenBeanConfig)) continue;
            return true;
        }
        return false;
    }

    private void resetInitializationOfContainedFormScreens(GroupBeanConfig groupBeanConfig) {
        Iterator iterator = groupBeanConfig.getBeanConfigs().iterator();
        while (iterator.hasNext()) {
            AbstractBeanConfig abstractBeanConfig = (AbstractBeanConfig)iterator.next();
            if (abstractBeanConfig instanceof ScreenBeanConfig) {
                Screen screen = ((ScreenBeanConfig)abstractBeanConfig).getOrInstantiateScreen(true);
                if (!(screen instanceof FormScreen)) continue;
                ((FormScreen)screen).resetFormComponents();
                continue;
            }
            if (!(abstractBeanConfig instanceof GroupBeanConfig)) continue;
            this.resetInitializationOfContainedFormScreens((GroupBeanConfig)abstractBeanConfig);
        }
    }

    private boolean enterGroup(GroupBeanConfig groupBeanConfig, boolean bl, boolean bl2) {
        this.groupStack.add(new GroupStackEntry(groupBeanConfig, groupBeanConfig.getBeanConfigs(), -1));
        return this.forward(bl, bl2);
    }

    private GroupStackEntry getCurrentStackEntry() {
        if (this.groupStack.isEmpty()) {
            return null;
        }
        return (GroupStackEntry)this.groupStack.getLast();
    }

    public void addHistory(ScreenBeanConfig screenBeanConfig) {
        LinkedList<GroupStackEntry> linkedList = new LinkedList<GroupStackEntry>();
        Object object = this.groupStack.iterator();
        while (object.hasNext()) {
            GroupStackEntry groupStackEntry = (GroupStackEntry)object.next();
            linkedList.add(groupStackEntry.copy());
        }
        object = new HistoryEntry(screenBeanConfig, linkedList);
        this.screenConfigHistory.add(object);
    }

    public ScreenBeanConfig removeLastHistoryItem() {
        if (this.screenConfigHistory.isEmpty()) {
            return null;
        }
        HistoryEntry historyEntry = (HistoryEntry)this.screenConfigHistory.removeLast();
        if (historyEntry == null) {
            return null;
        }
        return historyEntry.screenConfig;
    }

    private static class GroupStackEntry {
        private GroupBeanConfig groupConfig;
        private List screenConfigs;
        private int index;
        private ContextImpl.GroupState groupState = new ContextImpl.GroupState();

        private GroupStackEntry(GroupBeanConfig groupBeanConfig, List list, int n) {
            this.groupConfig = groupBeanConfig;
            this.screenConfigs = list;
            this.index = n;
        }

        public AbstractBeanConfig getCurrentConfig() {
            if (this.index < 0 || this.index > this.screenConfigs.size()) {
                return null;
            }
            return (AbstractBeanConfig)this.screenConfigs.get(this.index);
        }

        public GroupStackEntry copy() {
            return new GroupStackEntry(this.groupConfig, this.screenConfigs, this.index);
        }
    }

    private static class HistoryEntry {
        private ScreenBeanConfig screenConfig;
        private LinkedList groupStack;

        private HistoryEntry(ScreenBeanConfig screenBeanConfig, LinkedList linkedList) {
            this.screenConfig = screenBeanConfig;
            this.groupStack = linkedList;
        }
    }
}

