/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.controller;

import com.exe4j.runtime.WinLauncher;
import com.install4j.api.beans.ScriptProperty;
import com.install4j.runtime.beans.applications.Application;
import com.install4j.runtime.beans.applications.InstallerApplication;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.controller.ReturnToken;
import com.install4j.runtime.installer.controller.ScreenExecutor;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.launcher.Launcher;
import com.install4j.runtime.util.StreamConsumerThread;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import javax.swing.SwingUtilities;

class LanguageSelector {
    LanguageSelector() {
    }

    static void initSystemAndDefaultLanguage() {
        String string;
        String string2 = System.getProperty("install4j.systemLanguage");
        if (string2 == null || !string2.matches("\\w\\w")) {
            string2 = System.getProperty("user.language");
            System.setProperty("install4j.systemLanguage", string2);
        }
        if ((string = System.getProperty("install4j.defaultLanguage")) != null && string2.matches("\\w\\w|\\w\\w_\\w\\w")) {
            System.setProperty("user.language", string);
            Locale.setDefault(new Locale(string.substring(0, 2), string.length() == 5 ? string.substring(3, 5) : Locale.getDefault().getCountry()));
            System.setProperty("install4j.defaultLanguage", "");
        }
    }

    static void initLanguage(ContextImpl contextImpl, ScreenExecutor screenExecutor) {
        Object object;
        String string = contextImpl.getLanguageId();
        Application application = InstallerConfig.getCurrentApplication();
        if (application instanceof InstallerApplication && System.getProperty("install4j.language") == null && (object = ((InstallerApplication)application).getLanguageSelectionScript()) != null && !((ScriptProperty)object).getValue().equals("")) {
            try {
                string = (String)contextImpl.runScript((ScriptProperty)object, application, new Object[]{string});
                if (InstallerConfig.getCurrentInstance().getLanguageById(string) == null) {
                    string = null;
                }
            }
            catch (Exception exception) {
                Logger.getInstance().log(exception);
            }
        }
        if (string != null) {
            Messages.setLanguageConfig(InstallerConfig.getCurrentInstance().getLanguageById(string));
        } else {
            string = LanguageSelector.queryLanguage(screenExecutor);
            if (string == null) {
                InstallerUtil.exit(1);
            } else {
                contextImpl.setLanguageId(string);
                object = System.getProperty("exe4j.moduleName");
                if (object == null || !new File((String)object).exists() || InstallerUtil.isMacOS() || string.equals(System.getProperty("user.language")) || contextImpl.isConsole() || contextImpl.isUnattended() || Boolean.getBoolean("install4j.noSecondaryProcess")) {
                    Messages.setLanguageConfig(InstallerConfig.getCurrentInstance().getLanguageById(string));
                } else {
                    Logger.getImpl().switchToSecondaryProcess();
                    String[] stringArray = InstallerUtil.isWindows() ? WinLauncher.appendOriginalArgs(new String[]{object, "__i4j_lang_restart", "-Duser.language=" + string, "-Dinstall4j.language=" + string, "-Dinstall4j.systemLanguage=" + System.getProperty("install4j.systemLanguage"), "-Dexe4j.unextractedPositionRestart=" + Integer.getInteger("exe4j.unextractedPosition", 0)}) : Launcher.appendOriginalArgs(new String[]{"/bin/sh", object, "__i4j_lang_restart", "-Duser.language=" + string, "-Dinstall4j.language=" + string, "-Dinstall4j.systemLanguage=" + System.getProperty("install4j.systemLanguage")});
                    try {
                        Process process = Runtime.getRuntime().exec(stringArray, null, new File(System.getProperty("user.dir")));
                        StreamConsumerThread.consumeOutput(process);
                        try {
                            System.exit(process.waitFor());
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                            System.exit(1);
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        Messages.setLanguageConfig(InstallerConfig.getCurrentInstance().getLanguageById(string));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String queryLanguage(final ScreenExecutor screenExecutor) {
        final ReturnToken returnToken = new ReturnToken();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                screenExecutor.selectLanguage(returnToken);
            }
        });
        ReturnToken returnToken2 = returnToken;
        synchronized (returnToken2) {
            while (!returnToken.isWokenUp()) {
                try {
                    returnToken.wait();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
        return (String)returnToken.getReturnValue();
    }
}

